/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.component;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.DataGridView;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.ICellPopulator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.navigation.paging.IPageableItems;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.visit.IVisit;
import org.apache.wicket.util.visit.IVisitor;
import org.wicketstuff.egrid.column.EditableGridActionsPanel;
import org.wicketstuff.egrid.column.IColumnProvider;
import org.wicketstuff.egrid.component.IItemRefreashable;
import org.wicketstuff.egrid.model.GridOperationData;
import org.wicketstuff.egrid.model.OperationType;
import org.wicketstuff.egrid.provider.IEditableDataProvider;
import org.wicketstuff.egrid.toolbar.AbstractEditableGridToolbar;

public class EditableDataTable<T, S>
extends Panel
implements IPageableItems,
IColumnProvider<T, S> {
    private static final long serialVersionUID = 1L;
    private final EditableDataGridView<T, S> datagrid;
    private final WebMarkupContainer body;
    private final List<? extends IColumn<T, S>> columns;
    private final ToolbarsContainer topToolbars;
    private final ToolbarsContainer bottomToolbars;
    private final Caption caption;

    public EditableDataTable(String id, List<? extends IColumn<T, S>> newColumns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage, Class<T> clazz) {
        super(id);
        Args.notEmpty(newColumns, (String)"columns");
        this.columns = newColumns;
        this.caption = new Caption("caption", this.getCaptionModel());
        this.body = this.newBodyContainer("body");
        this.datagrid = this.newDataGrid(newColumns, dataProvider, rowsPerPage);
        this.topToolbars = new ToolbarsContainer("topToolbars");
        this.bottomToolbars = new ToolbarsContainer("bottomToolbars");
        this.body.add(new Component[]{this.datagrid});
        this.add(new Component[]{this.caption});
        this.add(new Component[]{this.body});
        this.add(new Component[]{this.topToolbars});
        this.add(new Component[]{this.bottomToolbars});
        this.init(clazz);
    }

    private void init(Class<T> clazz) {
        this.setOutputMarkupId(true);
    }

    private EditableDataGridView<T, S> newDataGrid(List<? extends IColumn<T, S>> columns, IEditableDataProvider<T, S> dataProvider, long rowsPerPage) {
        EditableDataGridView<T, S> datagrid = new EditableDataGridView<T, S>("rows", columns, dataProvider);
        datagrid.setItemsPerPage(rowsPerPage);
        return datagrid;
    }

    protected IModel<String> getCaptionModel() {
        return null;
    }

    protected WebMarkupContainer newBodyContainer(String id) {
        return new WebMarkupContainer(id);
    }

    public final void setTableBodyCss(String cssStyle) {
        this.body.add(new Behavior[]{AttributeModifier.replace((String)"class", (Serializable)((Object)cssStyle))});
    }

    public void addBottomToolbar(AbstractEditableGridToolbar toolbar) {
        this.addToolbar(toolbar, this.bottomToolbars);
    }

    public void addTopToolbar(AbstractEditableGridToolbar toolbar) {
        this.addToolbar(toolbar, this.topToolbars);
    }

    public final ToolbarsContainer getTopToolbars() {
        return this.topToolbars;
    }

    public final ToolbarsContainer getBottomToolbars() {
        return this.bottomToolbars;
    }

    public final WebMarkupContainer getBody() {
        return this.body;
    }

    public final Caption getCaption() {
        return this.caption;
    }

    public final IEditableDataProvider<T, S> getDataProvider() {
        return (IEditableDataProvider)this.datagrid.getDataProvider();
    }

    @Override
    public final List<? extends IColumn<T, S>> getColumns() {
        return this.columns;
    }

    public final long getCurrentPage() {
        return this.datagrid.getCurrentPage();
    }

    public final long getPageCount() {
        return this.datagrid.getPageCount();
    }

    public final long getRowCount() {
        return this.datagrid.getRowCount();
    }

    public final long getItemsPerPage() {
        return this.datagrid.getItemsPerPage();
    }

    public final void setCurrentPage(long page) {
        this.datagrid.setCurrentPage(page);
        this.onPageChanged();
    }

    public final EditableDataTable<T, S> setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.datagrid.setItemReuseStrategy(strategy);
        return this;
    }

    public void setItemsPerPage(long items) {
        this.datagrid.setItemsPerPage(items);
    }

    public long getItemCount() {
        return this.datagrid.getItemCount();
    }

    private void addToolbar(AbstractEditableGridToolbar toolbar, ToolbarsContainer container) {
        Args.notNull((Object)((Object)toolbar), (String)"toolbar");
        container.getRepeatingView().add(new Component[]{toolbar});
    }

    protected Item<IColumn<T, S>> newCellItem(String id, int index, IModel<IColumn<T, S>> model) {
        return new Item(id, index, model);
    }

    protected Item<T> newRowItem(String id, int index, IModel<T> model) {
        return new RowItem<T>(id, index, model);
    }

    protected void onDetach() {
        super.onDetach();
        for (IColumn<T, S> column : this.columns) {
            column.detach();
        }
    }

    protected void onPageChanged() {
    }

    public void onEvent(IEvent<?> event) {
        GridOperationData gridOperationData;
        if (event.getPayload() instanceof Item) {
            Item rowItem = (Item)event.getPayload();
            if (((EditableDataTable)rowItem.findParent(EditableDataTable.class)).equals(this)) {
                this.datagrid.refreash((Item<T>)rowItem);
                event.stop();
            }
        } else if (event.getPayload() instanceof GridOperationData && null != (gridOperationData = (GridOperationData)event.getPayload()) && OperationType.DELETE.equals((Object)gridOperationData.getOperationType()) && this.equals(gridOperationData.getTarget())) {
            this.getDataProvider().remove(gridOperationData.getData());
            event.stop();
        }
    }

    protected void onError(AjaxRequestTarget target) {
    }

    public static abstract class CssAttributeBehavior
    extends Behavior {
        private static final long serialVersionUID = 1L;

        protected abstract String getCssClass();

        public void onComponentTag(Component component, ComponentTag tag) {
            String className = this.getCssClass();
            if (!Strings.isEmpty((CharSequence)className)) {
                tag.append("class", (CharSequence)className, " ");
            }
        }
    }

    public static class RowItem<RI>
    extends Item<RI> {
        private static final long serialVersionUID = 1L;

        public RowItem(String id, int index, IModel<RI> model) {
            super(id, index, model);
            this.setOutputMarkupId(true);
            this.setMetaData(EditableGridActionsPanel.EDITING, Boolean.FALSE);
        }
    }

    private class EditableDataGridView<R, U>
    extends DataGridView<R>
    implements IItemRefreashable<R> {
        private static final long serialVersionUID = 1L;

        public EditableDataGridView(String id, List<? extends ICellPopulator<R>> populators, IEditableDataProvider<R, U> dataProvider) {
            super(id, populators, dataProvider);
        }

        protected Item newCellItem(String id, int index, IModel model) {
            Item item = EditableDataTable.this.newCellItem(id, index, model);
            final IColumn column = (IColumn)EditableDataTable.this.columns.get(index);
            if (column instanceof IStyledColumn) {
                item.add(new Behavior[]{new CssAttributeBehavior(){
                    private static final long serialVersionUID = 1L;

                    @Override
                    protected String getCssClass() {
                        return ((IStyledColumn)column).getCssClass();
                    }
                }});
            }
            return item;
        }

        protected Item<R> newRowItem(String id, int index, IModel<R> model) {
            return new RowItem<R>(id, index, model);
        }

        @Override
        public void refreash(Item<R> rowItem) {
            rowItem.removeAll();
            this.populateItem(rowItem);
        }
    }

    private static class Caption
    extends Label {
        private static final long serialVersionUID = 1L;

        public Caption(String id, IModel<String> model) {
            super(id, model);
        }

        protected void onConfigure() {
            this.setRenderBodyOnly(Strings.isEmpty((CharSequence)this.getDefaultModelObjectAsString()));
            super.onConfigure();
        }

        protected IModel<String> initModel() {
            return null;
        }
    }

    private static class ToolbarsContainer
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;
        private final RepeatingView toolbars = new RepeatingView("toolbars");

        private ToolbarsContainer(String id) {
            super(id);
            this.add(new Component[]{this.toolbars});
        }

        public RepeatingView getRepeatingView() {
            return this.toolbars;
        }

        public void onConfigure() {
            super.onConfigure();
            this.toolbars.configure();
            Boolean visible = (Boolean)this.toolbars.visitChildren((IVisitor)new IVisitor<Component, Boolean>(){

                public void component(Component object, IVisit<Boolean> visit) {
                    object.configure();
                    if (object.isVisible()) {
                        visit.stop((Object)Boolean.TRUE);
                    } else {
                        visit.dontGoDeeper();
                    }
                }
            });
            if (visible == null) {
                visible = false;
            }
            this.setVisible(visible);
        }
    }
}

