/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.javaee;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.util.lang.Objects;

public class JndiObjectLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private Class<?> beanType;
    private String beanName;

    public JndiObjectLocator(String beanId, Class<?> beanType) {
        if (beanType == null) {
            throw new IllegalArgumentException("[beanType] argument cannot be null");
        }
        if (beanId == null) {
            throw new IllegalArgumentException("[beanId] argument cannot be null");
        }
        this.beanType = beanType;
        this.beanName = beanId;
    }

    public Object locateProxyTarget() {
        return JndiObjectLocator.lookup(this.beanName, this.beanType);
    }

    private static Object lookup(String name, Class<?> type) {
        String lookupName = "java:comp/env/" + name;
        try {
            InitialContext ic = new InitialContext();
            return ic.lookup(lookupName);
        }
        catch (NamingException e) {
            String errorMessage = "Could not locate resource of class [[" + type + "]] and name [[" + name + "]] ";
            throw new RuntimeException(errorMessage, e);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof JndiObjectLocator) {
            JndiObjectLocator other = (JndiObjectLocator)obj;
            return this.beanType.equals(other.beanType) && Objects.equal((Object)this.beanName, (Object)other.beanName);
        }
        return false;
    }

    public int hashCode() {
        int hashcode = this.beanType.hashCode();
        if (this.beanName != null) {
            hashcode += 127 * this.beanName.hashCode();
        }
        return hashcode;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }
}

