/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.javaee;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.util.lang.Objects;
import org.wicketstuff.javaee.naming.IJndiNamingStrategy;

public class JavaEEBeanLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private String beanName;
    private Class<?> beanType;
    private IJndiNamingStrategy namingStrategy;

    public JavaEEBeanLocator(String beanId, Class<?> beanType, IJndiNamingStrategy namingStrategy) {
        if (beanType == null) {
            throw new IllegalArgumentException("[beanType] argument cannot be null");
        }
        this.beanType = beanType;
        this.beanName = beanId;
        this.namingStrategy = namingStrategy;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaEEBeanLocator) {
            JavaEEBeanLocator other = (JavaEEBeanLocator)obj;
            return this.beanType.equals(other.beanType) && Objects.equal((Object)this.beanName, (Object)other.beanName);
        }
        return false;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Class<?> getBeanType() {
        return this.beanType;
    }

    public int hashCode() {
        int hashcode = this.beanType.hashCode();
        if (this.beanName != null) {
            hashcode += 127 * this.beanName.hashCode();
        }
        return hashcode;
    }

    public Object locateProxyTarget() {
        if (this.beanName != null && this.beanName.length() > 0) {
            return this.lookupEjb(this.beanName, this.beanType);
        }
        return this.lookupEjb(null, this.beanType);
    }

    private String calculateName(String name, Class<?> type) {
        return this.namingStrategy.calculateName(name, type);
    }

    private Object lookupEjb(String name, Class<?> type) {
        String lookupName = this.calculateName(name, type);
        try {
            InitialContext ic = new InitialContext();
            return ic.lookup(lookupName);
        }
        catch (NamingException e) {
            String errorMessage = "Could not locate ejb of class [[" + type + "]] ";
            if (name != null && name.length() > 0) {
                errorMessage = errorMessage + "and name [[" + name + "]] ";
            }
            throw new RuntimeException(errorMessage, e);
        }
    }
}

