/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior;

import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.head.IHeaderResponse;

public class CompositeBehavior
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final Iterable<Behavior> behaviors_;

    public CompositeBehavior(Behavior ... behaviors) {
        this(Arrays.asList(behaviors));
    }

    public CompositeBehavior(Iterable<Behavior> behaviors) {
        this.behaviors_ = behaviors;
    }

    public void afterRender(Component arg0) {
        for (Behavior behavior : this.behaviors_) {
            behavior.afterRender(arg0);
        }
    }

    public void beforeRender(Component arg0) {
        for (Behavior behavior : this.behaviors_) {
            behavior.beforeRender(arg0);
        }
    }

    public void bind(Component arg0) {
        for (Behavior behavior : this.behaviors_) {
            behavior.bind(arg0);
        }
    }

    public void detach(Component arg0) {
        for (Behavior behavior : this.behaviors_) {
            behavior.detach(arg0);
        }
    }

    public void exception(Component component, RuntimeException aException) {
        for (Behavior behavior : this.behaviors_) {
            behavior.onException(component, aException);
        }
    }

    public boolean getStatelessHint(Component arg0) {
        boolean back = true;
        for (Behavior behavior : this.behaviors_) {
            back = back && behavior.getStatelessHint(arg0);
        }
        return back;
    }

    public boolean isEnabled(Component arg0) {
        boolean back = true;
        for (Behavior behavior : this.behaviors_) {
            back = back && behavior.isEnabled(arg0);
        }
        return back;
    }

    public boolean isTemporary(Component component) {
        boolean back = true;
        for (Behavior behavior : this.behaviors_) {
            back = back && behavior.isTemporary(component);
        }
        return back;
    }

    public void onComponentTag(Component aComponent, ComponentTag aTag) {
        for (Behavior behavior : this.behaviors_) {
            behavior.onComponentTag(aComponent, aTag);
        }
    }

    public void renderHead(Component component, IHeaderResponse response) {
        super.renderHead(component, response);
        for (Behavior behavior : this.behaviors_) {
            behavior.renderHead(component, response);
        }
    }
}

