/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IComponentAssignedModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.IWrapModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class ReplacingResourceModel
extends AbstractReadOnlyModel<String>
implements IComponentAssignedModel<String> {
    private static final long serialVersionUID = 1L;
    private final String resourceKey;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\$\\{(.*?)\\}");

    public ReplacingResourceModel(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    public String getObject() {
        return this.getReplacedResourceString(null);
    }

    public IWrapModel<String> wrapOnAssignment(Component component) {
        return new AssignmentWrapper(component);
    }

    private String getReplacedResourceString(Component component) {
        String resourceKeyValue = Application.get().getResourceSettings().getLocalizer().getString(this.resourceKey, component, null, null, null, (IModel)null);
        StringBuffer output = new StringBuffer();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(resourceKeyValue);
        while (matcher.find()) {
            String replacedPlaceHolder = Application.get().getResourceSettings().getLocalizer().getString(matcher.group(1), component, null, null, null, (IModel)null);
            matcher.appendReplacement(output, replacedPlaceHolder);
        }
        matcher.appendTail(output);
        return output.toString();
    }

    private class AssignmentWrapper
    extends LoadableDetachableModel<String>
    implements IWrapModel<String> {
        private static final long serialVersionUID = 1L;
        private final Component component;

        public AssignmentWrapper(Component component) {
            this.component = component;
        }

        public IModel<String> getWrappedModel() {
            return ReplacingResourceModel.this;
        }

        protected String load() {
            return ReplacingResourceModel.this.getReplacedResourceString(this.component);
        }

        protected void onDetach() {
            ReplacingResourceModel.this.detach();
        }
    }
}

