/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.ObjectId;

public final class ImmutableTree
implements ISerializedObjectTree {
    final ObjectId id;
    final Class<?> type;
    final String label;
    final int size;
    final int childSize;
    final List<ISerializedObjectTree> children;

    public ImmutableTree(ObjectId id, Class<?> type, String label, int size, List<? extends ISerializedObjectTree> children) {
        this.id = id;
        this.type = type;
        this.label = label;
        this.size = size;
        ArrayList<? extends ISerializedObjectTree> lchildren = new ArrayList<ISerializedObjectTree>();
        lchildren.addAll(children);
        this.children = Collections.unmodifiableList(lchildren);
        int childSize = 0;
        for (ISerializedObjectTree iSerializedObjectTree : children) {
            childSize = childSize + iSerializedObjectTree.childSize() + iSerializedObjectTree.size();
        }
        this.childSize = childSize;
    }

    @Override
    public ObjectId id() {
        return this.id;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int childSize() {
        return this.childSize;
    }

    @Override
    public Class<? extends Object> type() {
        return this.type;
    }

    @Override
    public String label() {
        return this.label;
    }

    @Override
    public List<? extends ISerializedObjectTree> children() {
        return this.children;
    }

    public String toString() {
        return "#" + this.id + " " + this.type + "(" + this.label + ") [" + this.children().size() + "]";
    }
}

