/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.ImmutableTree;
import org.wicketstuff.pageserializer.common.analyze.report.TreeType;

class TreeTypeMap {
    Map<TreeType, List<ISerializedObjectTree>> map;

    public TreeTypeMap(List<? extends ISerializedObjectTree> source) {
        LinkedHashMap<TreeType, List<ISerializedObjectTree>> typeMap = new LinkedHashMap<TreeType, List<ISerializedObjectTree>>();
        for (ISerializedObjectTree iSerializedObjectTree : source) {
            TreeType key = new TreeType(iSerializedObjectTree);
            ArrayList<ISerializedObjectTree> list = (ArrayList<ISerializedObjectTree>)typeMap.get(key);
            if (list == null) {
                list = new ArrayList<ISerializedObjectTree>();
                typeMap.put(key, list);
            }
            list.add(iSerializedObjectTree);
        }
        this.map = typeMap;
    }

    public List<ISerializedObjectTree> compressedResult() {
        ArrayList<ISerializedObjectTree> ret = new ArrayList<ISerializedObjectTree>();
        for (Map.Entry<TreeType, List<ISerializedObjectTree>> entry : this.map.entrySet()) {
            List<ISerializedObjectTree> list = entry.getValue();
            ret.add(list.size() == 1 ? list.get(0) : TreeTypeMap.compress(list));
        }
        return ret;
    }

    protected static ISerializedObjectTree compress(List<? extends ISerializedObjectTree> list) {
        ISerializedObjectTree first = list.get(0);
        Class<? extends Object> type = first.type();
        String label = TreeTypeMap.allLables(list);
        int size = 0;
        for (ISerializedObjectTree iSerializedObjectTree : list) {
            size += iSerializedObjectTree.size();
        }
        return new ImmutableTree(null, type, label, size, TreeTypeMap.compressedChildren(list));
    }

    protected static List<? extends ISerializedObjectTree> compressedChildren(List<? extends ISerializedObjectTree> source) {
        ArrayList<ISerializedObjectTree> ret = new ArrayList<ISerializedObjectTree>();
        ArrayList<Object> childrens = new ArrayList<Object>();
        int columns = 0;
        for (ISerializedObjectTree iSerializedObjectTree : source) {
            List<? extends ISerializedObjectTree> sortedChildren = TreeTypeMap.sortByTreeType(iSerializedObjectTree.children());
            columns = sortedChildren.size();
            childrens.add(sortedChildren);
        }
        for (int i = 0; i < columns; ++i) {
            ArrayList arrayList = new ArrayList();
            for (List list : childrens) {
                arrayList.add(list.get(i));
            }
            ISerializedObjectTree compressed = TreeTypeMap.compress(arrayList);
            ret.add(compressed);
        }
        return ret;
    }

    private static List<? extends ISerializedObjectTree> sortByTreeType(List<? extends ISerializedObjectTree> source) {
        ArrayList<? extends ISerializedObjectTree> ret = new ArrayList<ISerializedObjectTree>();
        ret.addAll(source);
        Collections.sort(ret, new Comparator<ISerializedObjectTree>(){

            @Override
            public int compare(ISerializedObjectTree o1, ISerializedObjectTree o2) {
                return new TreeType(o1).compareTo(new TreeType(o2));
            }
        });
        return ret;
    }

    protected static String allLables(List<? extends ISerializedObjectTree> list) {
        LinkedHashSet<String> labels = new LinkedHashSet<String>();
        for (ISerializedObjectTree iSerializedObjectTree : list) {
            if (iSerializedObjectTree.label() == null) continue;
            labels.add(iSerializedObjectTree.label());
        }
        if (labels.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean bl = true;
        for (String s : labels) {
            boolean bl2;
            if (bl2) {
                bl2 = false;
            } else {
                sb.append("|");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public boolean hasLessEntries(int size) {
        return this.map.size() < size;
    }
}

