/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.analyze.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTree;
import org.wicketstuff.pageserializer.common.analyze.ISerializedObjectTreeProcessor;
import org.wicketstuff.pageserializer.common.analyze.report.IReportOutput;
import org.wicketstuff.pageserializer.common.analyze.report.IReportRenderer;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.AttributeBuilder;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.Column;
import org.wicketstuff.pageserializer.common.analyze.reportbuilder.Report;

public class TypeSizeReport
implements ISerializedObjectTreeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(TypeSizeReport.class);
    static final Column emptyFirst = new Column("", new AttributeBuilder().set(Column.Separator, "|").build());
    static final Column label = new Column("Type", new AttributeBuilder().set(Column.FillAfter, Character.valueOf(' ')).set(Column.Separator, "|").build());
    static final Column size = new Column("bytes", new AttributeBuilder().set(Column.Align.Right).set(Column.FillBefore, Character.valueOf(' ')).set(Column.Separator, "|").build());
    private final IReportOutput reportOutput;

    public TypeSizeReport(IReportOutput reportOutput) {
        this.reportOutput = reportOutput;
    }

    @Override
    public void process(ISerializedObjectTree tree) {
        this.reportOutput.write(tree, new IReportRenderer(){

            @Override
            public String render(ISerializedObjectTree tree) {
                HashMap map = new HashMap();
                TypeSizeReport.this.process(tree, map);
                ArrayList sorted = new ArrayList();
                sorted.addAll(map.entrySet());
                Collections.sort(sorted, new Comparator<Map.Entry<Class<?>, Counter>>(){

                    @Override
                    public int compare(Map.Entry<Class<?>, Counter> o1, Map.Entry<Class<?>, Counter> o2) {
                        int s1 = o1.getValue().size;
                        int s2 = o2.getValue().size;
                        return s1 == s2 ? 0 : (s1 > s2 ? -1 : 1);
                    }
                });
                Report report = new Report("TypeSizeReport\n");
                for (Map.Entry entry : sorted) {
                    report.newRow().set(label, 0, ((Class)entry.getKey()).getName()).set(size, 0, "" + ((Counter)entry.getValue()).size);
                }
                String result = report.export(emptyFirst, size, label).separateColumnNamesWith('-').tableBorderWith('=').asString();
                return result;
            }
        });
    }

    private void process(ISerializedObjectTree tree, Map<Class<?>, Counter> map) {
        Counter counter = this.getOrCreate(map, tree.type());
        counter.increment(tree.size());
        for (ISerializedObjectTree iSerializedObjectTree : tree.children()) {
            this.process(iSerializedObjectTree, map);
        }
    }

    private Counter getOrCreate(Map<Class<?>, Counter> map, Class<? extends Object> type) {
        Counter ret = map.get(type);
        if (ret == null) {
            ret = new Counter();
            map.put(type, ret);
        }
        return ret;
    }

    static class Counter {
        int size;

        Counter() {
        }

        void increment(int diff) {
            this.size += diff;
        }
    }
}

