/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.pageserializer.common.listener;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.pageserializer.common.listener.ISerializationListener;

public class LoggingSerializationListener
implements ISerializationListener {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingSerializationListener.class);

    @Override
    public void begin(Object object) {
        LOG.debug("Start for object: '{}'", object.getClass());
    }

    @Override
    public void before(int position, Object object) {
        LOG.debug("Start at '{}' byte for object:  '{}'", (Object)position, object != null ? object.getClass() : "NULL");
    }

    @Override
    public void after(int position, Object object) {
        LOG.debug("End at   '{}' bytes for object: '{}'", (Object)position, object != null ? object.getClass() : "NULL");
    }

    @Override
    public void end(Object object, Exception exception) {
        LOG.debug("End for object:   '{}'", object.getClass());
    }
}

