/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.apt;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.wikbook.apt.CatalogBuilder;
import org.wikbook.apt.StringPair;
import org.wikbook.apt.annotations.Documented;
import org.wikbook.apt.model.Catalog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_5)
@SupportedAnnotationTypes(value={"org.wikbook.apt.annotations.Documented"})
public class WikbookProcessor
extends AbstractProcessor {
    private Trees trees;
    private ProcessingEnvironment pe;
    private int count;
    private Set<StringPair> processed;

    @Override
    public void init(ProcessingEnvironment pe) {
        super.init(pe);
        this.trees = Trees.instance(pe);
        this.pe = pe;
        this.processed = new HashSet<StringPair>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        if (this.count++ > 0) {
            return true;
        }
        ArrayList<Element> originatingElts = new ArrayList<Element>();
        CatalogBuilder builder = new CatalogBuilder();
        for (Element element : roundEnvironment.getElementsAnnotatedWith(Documented.class)) {
            originatingElts.add(element);
            Documented documented = element.getAnnotation(Documented.class);
            TreePath tp = this.trees.getPath(element);
            CompilationUnitTree cut = tp.getCompilationUnit();
            JavaFileObject src = cut.getSourceFile();
            String fragmentId = documented.id();
            if (fragmentId.length() == 0) {
                Element p = element;
                while (fragmentId.length() == 0) {
                    switch (p.getKind()) {
                        case CLASS: 
                        case INTERFACE: 
                        case ENUM: 
                        case ANNOTATION_TYPE: {
                            fragmentId = ((TypeElement)p).getQualifiedName().toString();
                            break;
                        }
                    }
                    p = p.getEnclosingElement();
                }
            }
            String annotationId = documented.id();
            StringPair a = new StringPair(src.getName(), annotationId);
            if (this.processed.contains(a)) continue;
            try {
                builder.build(annotationId, fragmentId, src);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.processed.add(a);
        }
        ObjectOutputStream oos = null;
        try {
            Filer filer = this.processingEnv.getFiler();
            FileObject file = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "catalog.ser", originatingElts.toArray(new Element[originatingElts.size()]));
            oos = new ObjectOutputStream(file.openOutputStream());
            Catalog catalog = builder.getCatalog();
            oos.writeObject(catalog);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return true;
    }
}

