/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.codesource;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wikbook.codesource.CodeSourceBuilder;
import org.wikbook.codesource.CodeSourceBuilderContext;
import org.wikbook.codesource.SignedMemberSource;
import org.wikbook.codesource.TypeSource;
import org.wikbook.core.Utils;
import org.wikbook.core.codesource.CodeContext;
import org.wikbook.core.codesource.JavaCodeLink;
import org.wikbook.text.TextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeProcessor {
    public static final String WHITE_NON_CR = "[ \t\\x0B\f\r]";
    public static final Pattern CALLOUT_ANCHOR_PATTERN = Pattern.compile("//[ \t\\x0B\f\r]*<([0-9]+)>(.*)$", 8);
    public static final Pattern CALLOUT_DEF_PATTERN = Pattern.compile("^[ \t\\x0B\f\r]*//[ \t\\x0B\f\r]*=([0-9]+)=[ \t\\x0B\f\r](\\S.*)$", 8);
    public static final Pattern BEGIN_CHUNK_PATTERN = Pattern.compile("^[ \t\\x0B\f\r]*//[ \t\\x0B\f\r]*-([0-9]+)-[ \t\\x0B\f\r]*$");
    public static final Pattern BLANK_LINE_PATTERN = Pattern.compile("^[ \t\\x0B\f\r]*$");
    public static final Pattern BILTO = Pattern.compile("^(?:(?:[ \t\\x0B\f\r]*//[ \t\\x0B\f\r]*-([0-9]+)-[ \t\\x0B\f\r]*)|(?:[ \t\\x0B\f\r]*))$", 8);
    public static final Pattern JAVA_INCLUDE_PATTERN = Pattern.compile("\\{@(include|javadoc)\\s+([^\\s]+)\\s*(\\{[0-9]+(?:,[0-9]+)*\\})?\\s*\\}");

    private void printJavaLine(String s, CodeContext ctx) {
        Matcher coDefMatcher = CALLOUT_DEF_PATTERN.matcher(s);
        int pre = 0;
        StringBuilder buf = new StringBuilder();
        while (coDefMatcher.find()) {
            String id = coDefMatcher.group(1);
            String text = coDefMatcher.group(2).trim();
            buf.append(s, pre, coDefMatcher.start());
            ctx.setCallout(id, text);
            pre = coDefMatcher.end();
        }
        buf.append(s, pre, s.length());
        s = buf.toString();
        TextArea ta = new TextArea(s);
        Matcher matcher = CALLOUT_ANCHOR_PATTERN.matcher(s);
        int prev = 0;
        while (matcher.find()) {
            String id = matcher.group(1);
            ctx.writeContent(ta.clip(ta.position(prev), ta.position(matcher.start())));
            ctx.writeCallout(id);
            String text = matcher.group(2);
            if (!text.matches("\\s*")) {
                ctx.setCallout(id, text.trim());
            }
            prev = matcher.end();
        }
        ctx.writeContent(ta.clip(ta.position(prev)));
    }

    private void printJavaSource(SignedMemberSource methodSource, CodeContext ctx, Set<String> chunkIds) {
        String source = methodSource.getClip();
        int from = source.indexOf(123);
        int to = source.lastIndexOf(125);
        source = source.substring(from + 1, to);
        this.printJavaSource(source, ctx, chunkIds);
    }

    private void printJavaSource(String source, CodeContext ctx) {
        Iterator<String> i = Utils.split(source).iterator();
        while (i.hasNext()) {
            String line = i.next();
            Matcher matcher = BEGIN_CHUNK_PATTERN.matcher(line);
            if (matcher.matches()) continue;
            if (i.hasNext()) {
                this.printJavaLine(line + "\n", ctx);
                continue;
            }
            this.printJavaLine(line, ctx);
        }
    }

    private void printJavaSource(String source, CodeContext ctx, Set<String> chunkIds) {
        boolean matches = false;
        for (String line : Utils.split(source)) {
            if (BLANK_LINE_PATTERN.matcher(line).matches()) {
                matches = false;
                continue;
            }
            Matcher matcher = BEGIN_CHUNK_PATTERN.matcher(line);
            if (matcher.matches()) {
                String chunkId = matcher.group(1);
                matches = chunkIds == null || chunkIds.contains(chunkId);
                continue;
            }
            if (!matches) continue;
            this.printJavaLine(line + "\n", ctx);
        }
    }

    public void parse(String s, final CodeContext ctx) {
        int prev = 0;
        Matcher matcher = JAVA_INCLUDE_PATTERN.matcher(s);
        while (matcher.find()) {
            JavaCodeLink l = JavaCodeLink.parse(matcher.group(2));
            CodeSourceBuilder builder = new CodeSourceBuilder(new CodeSourceBuilderContext(){

                public InputStream getResource(String path) {
                    try {
                        return ctx.resolveResources(path);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        return null;
                    }
                }
            });
            this.printJavaSource(s.substring(prev, matcher.start()), ctx);
            TypeSource typeSource = builder.buildClass(l.getFQN());
            Object source = l.getMember() != null ? typeSource.findMember(l.getMember()) : typeSource;
            if (source != null) {
                if ("include".equals(matcher.group(1))) {
                    if (matcher.group(3) != null) {
                        String subset = matcher.group(3);
                        String a = subset.substring(1, subset.length() - 1);
                        String[] ids = a.split(",");
                        this.printJavaSource((SignedMemberSource)source, ctx, new HashSet<String>(Arrays.asList(ids)));
                    } else {
                        this.printJavaSource(source.getClip(), ctx);
                    }
                } else if ("javadoc".equals(matcher.group(1)) && source.getJavaDoc() != null) {
                    String javadoc = source.getJavaDoc();
                    ctx.writeContent(javadoc);
                }
            } else {
                ctx.writeContent("Could not locate the " + l + " source");
            }
            prev = matcher.end();
        }
        this.printJavaSource(s.substring(prev), ctx);
    }
}

