/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block.list;

import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.ListItemElement;
import org.wikbook.core.model.content.block.list.TermElement;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

public class VariableListElement
extends BlockElement {
    private final ElementContainer<DocbookElement> container = new ElementContainer<DocbookElement>(DocbookElement.class);
    private final String title;

    public VariableListElement(String title) {
        this.title = title;
    }

    public boolean append(DocbookElement elt) {
        if (elt instanceof TermElement || elt instanceof ListItemElement) {
            return this.container.append(elt);
        }
        return false;
    }

    public void writeTo(XMLEmitter xml) {
        ElementEmitter listXML = xml.element("variablelist");
        if (this.title != null) {
            ((XMLEmitter)listXML).element("title").content(this.title);
        }
        ElementEmitter entryXML = null;
        for (DocbookElement elt : this.container) {
            if (elt instanceof TermElement) {
                entryXML = ((XMLEmitter)listXML).element("varlistentry");
            }
            elt.writeTo(entryXML);
        }
    }
}

