/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.model.content.block;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.wikbook.codesource.CodeSourceBuilder;
import org.wikbook.codesource.TypeSource;
import org.wikbook.model.content.block.BlockElement;
import org.wikbook.model.content.block.CodeLanguage;
import org.wikbook.model.content.block.JavaCodeLink;
import org.wikbook.xml.ElementEmitter;
import org.wikbook.xml.OutputFormat;
import org.wikbook.xml.XML;
import org.wikbook.xml.XMLEmitter;

public class ProgramListingElement
extends BlockElement {
    private static final Pattern JAVA_INCLUDE_PATTERN = Pattern.compile("\\{@(include|javadoc)\\s+([^\\s]+)\\}");
    private final String language;
    private final Integer indent;
    private final String content;

    public ProgramListingElement(String language, Integer indent, String content) {
        this.language = language;
        this.indent = indent;
        this.content = content;
    }

    public void writeTo(XMLEmitter xml) {
        ElementEmitter programListingXML = xml.element("programlisting");
        CodeLanguage codeLanguage = CodeLanguage.UNKNOWN;
        if (this.language != null) {
            if ("java".equalsIgnoreCase(this.language)) {
                codeLanguage = CodeLanguage.JAVA;
            } else if ("xml".equalsIgnoreCase(this.language)) {
                codeLanguage = CodeLanguage.XML;
            }
        }
        String bilto = this.content;
        switch (codeLanguage) {
            case XML: {
                if (this.indent != null) {
                    try {
                        Transformer transformer = XML.createTransformer(new OutputFormat(this.indent, true));
                        StringWriter writer = new StringWriter();
                        transformer.transform(new StreamSource(new StringReader(this.content)), new StreamResult(writer));
                        bilto = writer.toString();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        bilto = "Exception occured, see logs";
                    }
                }
                programListingXML.content(bilto, true);
                break;
            }
            case UNKNOWN: {
                programListingXML.content(bilto, true);
                break;
            }
            case JAVA: {
                bilto = ProgramListingElement.parse(bilto);
                programListingXML.content(bilto, true);
            }
        }
    }

    public static String parse(String s) {
        Matcher matcher = JAVA_INCLUDE_PATTERN.matcher(s);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            JavaCodeLink l = JavaCodeLink.parse(matcher.group(2));
            CodeSourceBuilder builder = new CodeSourceBuilder();
            TypeSource source = builder.buildClass(l.getFQN());
            Object blah = l.getMember() != null ? source.findMember(l.getMember()) : source;
            if ("include".equals(matcher.group(1))) {
                matcher.appendReplacement(sb, blah.getClip());
                continue;
            }
            if (!"javadoc".equals(matcher.group(1)) || blah.getJavaDoc() == null) continue;
            matcher.appendReplacement(sb, blah.getJavaDoc());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }
}

