/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.inline;

import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.inline.InlineElement;
import org.wikbook.core.model.content.inline.TextFormat;
import org.wikbook.core.xml.XMLEmitter;

public class FormatElement
extends InlineElement {
    private ElementContainer<InlineElement> container = new ElementContainer<InlineElement>(InlineElement.class);
    private final TextFormat format;

    public FormatElement(TextFormat format) {
        this.format = format;
    }

    public boolean append(DocbookElement elt) {
        if (elt instanceof InlineElement) {
            return this.container.append(elt);
        }
        return false;
    }

    public void writeTo(XMLEmitter xml) {
        switch (this.format) {
            case BOLD: {
                this.container.writeTo(xml.element("emphasis").withAttribute("role", "bold"));
                break;
            }
            case ITALIC: {
                this.container.writeTo(xml.element("emphasis").withAttribute("role", "italic"));
                break;
            }
            case CODE: 
            case MONOSPACE: {
                this.container.writeTo(xml.element("code"));
                break;
            }
            case SUPERSCRIPT: {
                this.container.writeTo(xml.element("superscript"));
                break;
            }
            case SUBSCRIPT: {
                this.container.writeTo(xml.element("subscript"));
                break;
            }
            case UNDERLINE: {
                this.container.writeTo(xml.element("emphasis").withAttribute("role", "underline"));
                break;
            }
            case STRIKE: {
                this.container.writeTo(xml.element("emphasis").withAttribute("role", "strikethrough"));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

