/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.block;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.wikbook.core.ResourceType;
import org.wikbook.core.Utils;
import org.wikbook.core.WikletContext;
import org.wikbook.core.codesource.CodeContext;
import org.wikbook.core.codesource.CodeProcessor;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.Loader;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.CalloutElement;
import org.wikbook.core.model.content.block.DocumentFormatterFilter;
import org.wikbook.core.model.content.block.LanguageSyntax;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.OutputFormat;
import org.wikbook.core.xml.XML;
import org.wikbook.core.xml.XMLEmitter;
import org.wikbook.text.Position;
import org.wikbook.text.TextArea;
import org.xml.sax.InputSource;

public class ProgramListingElement
extends BlockElement {
    private final ElementContainer<CalloutElement> callouts;
    private final LanguageSyntax languageSyntax;
    private final Integer indent;
    private final String content;
    private final WikletContext context;
    private final boolean highlightCode;
    private String listing;
    private final DocumentBuilder documentBuilder;
    private final XPath xpath;

    public ProgramListingElement(WikletContext context, LanguageSyntax languageSyntax, Integer indent, String content, boolean highlightCode) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(true);
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
        this.context = context;
        this.languageSyntax = languageSyntax;
        this.indent = indent;
        this.content = content;
        this.highlightCode = highlightCode;
        this.callouts = new ElementContainer<CalloutElement>(CalloutElement.class);
        this.documentBuilder = documentBuilder;
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void performIncludes(Element elt) {
        if ("urn:wikbook:internal".equals(elt.getNamespaceURI()) && "include".equals(elt.getLocalName())) {
            String hrefAttr = elt.getAttribute("href");
            Element replacementElt = null;
            try {
                URL url = this.context.resolveResource(ResourceType.XML, hrefAttr);
                if (url != null) {
                    Document includedDoc = this.documentBuilder.parse(url.openStream());
                    if (elt.hasAttribute("xpath")) {
                        String xpathAttr = elt.getAttribute("xpath");
                        XPathExpression xpathExpr = this.xpath.compile(xpathAttr);
                        Node resolvedNode = (Node)xpathExpr.evaluate(includedDoc, XPathConstants.NODE);
                        if (!(resolvedNode instanceof Element)) throw new Exception("Target of xpath expression " + xpathAttr + " does not resolve to an XML element but to " + resolvedNode);
                        replacementElt = (Element)elt.getOwnerDocument().importNode(resolvedNode, true);
                    } else {
                        Element includedElt = includedDoc.getDocumentElement();
                        replacementElt = (Element)elt.getOwnerDocument().importNode(includedElt, true);
                    }
                }
            }
            catch (Exception e) {
                Element errorElt = elt.getOwnerDocument().createElement("wikbook:error");
                elt.getOwnerDocument().createTextNode(Utils.toString(e));
                replacementElt = errorElt;
            }
            if (replacementElt == null) return;
            elt.getParentNode().replaceChild(replacementElt, elt);
            return;
        }
        for (Element childElt : XML.elements(elt)) {
            this.performIncludes(childElt);
        }
    }

    public void process(Loader loader) {
        String bilto;
        switch (this.languageSyntax) {
            case XML: {
                try {
                    String data = "<root xmlns:wikbook=\"urn:wikbook:internal\">" + this.content + "</root>";
                    Document doc = this.documentBuilder.parse(new InputSource(new StringReader(data)));
                    Element docElt = doc.getDocumentElement();
                    this.performIncludes(docElt);
                    if (this.indent != null) {
                        XML.removeWhiteSpace(docElt);
                    }
                    StringWriter writer = new StringWriter();
                    TransformerHandler serializer = XML.createTransformerHandler(new OutputFormat(this.indent, false));
                    serializer.setResult(new StreamResult(writer));
                    Transformer domToSAX = TransformerFactory.newInstance().newTransformer();
                    domToSAX.transform(new DOMSource(doc), new SAXResult(new DocumentFormatterFilter(serializer)));
                    data = writer.toString();
                    TextArea ta = new TextArea(data);
                    ta.trimLeft();
                    bilto = ta.getText();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    bilto = "Exception occured, see logs";
                }
                break;
            }
            case JAVA: {
                CodeContextImpl ctx = new CodeContextImpl();
                new CodeProcessor().parse(this.content, ctx);
                for (Map.Entry callout : ctx.callouts.entrySet()) {
                    if (((Callout)callout.getValue()).text == null) continue;
                    CalloutElement calloutElt = new CalloutElement(((Callout)callout.getValue()).ids, ((Callout)callout.getValue()).text);
                    this.push(calloutElt);
                    loader.load(new StringReader(((Callout)callout.getValue()).text));
                    this.merge();
                }
                bilto = ctx.sb.toString();
                break;
            }
            default: {
                bilto = this.content;
            }
        }
        this.listing = bilto;
    }

    public boolean append(DocbookElement elt) {
        return this.callouts.append(elt);
    }

    public void writeTo(XMLEmitter xml) {
        ElementEmitter programListingCoXML = xml.element("programlistingco");
        ElementEmitter areaspecXML = programListingCoXML.element("areaspec").withAttribute("units", "linecolumn");
        for (CalloutElement calloutElt : this.callouts) {
            for (Map.Entry<String, Position> target : calloutElt.getIds().entrySet()) {
                areaspecXML.element("area").withAttribute("id", target.getKey() + "-co").withAttribute("linkends", target.getKey()).withAttribute("coords", target.getValue().getLine() + 1 + " " + (target.getValue().getColumn() + 1));
            }
        }
        ElementEmitter programListingXML = programListingCoXML.element("programlisting");
        if (this.highlightCode && this.languageSyntax != LanguageSyntax.UNKNOWN) {
            programListingXML.withAttribute("language", this.languageSyntax.name().toLowerCase());
        }
        if (this.callouts.isNotEmpty()) {
            this.callouts.writeTo(programListingCoXML.element("calloutlist"));
        }
        programListingXML.content(this.listing, true);
    }

    private static class Callout {
        private String text;
        private final LinkedHashMap<String, Position> ids = new LinkedHashMap();

        private Callout() {
        }
    }

    private class CodeContextImpl
    implements CodeContext {
        private final StringBuilder sb = new StringBuilder();
        private final TreeMap<String, Callout> callouts = new TreeMap();
        private final Random random = new Random();

        private CodeContextImpl() {
        }

        public void writeContent(String content) {
            this.sb.append(content);
        }

        public void writeCallout(String index) {
            String coId = "" + Math.abs(this.random.nextLong());
            TextArea ta = new TextArea(this.sb.toString());
            Position pos = ta.position(this.sb.length());
            Callout callout = this.callouts.get(index);
            if (callout == null) {
                callout = new Callout();
                this.callouts.put(index, callout);
            }
            this.writeContent(" ");
            callout.ids.put(coId, pos);
        }

        public void setCallout(String index, String text) {
            Callout callout = this.callouts.get(index);
            if (callout == null) {
                callout = new Callout();
                this.callouts.put(index, callout);
            }
            callout.text = text;
        }

        public InputStream resolveResources(String id) throws IOException {
            List<URL> list = ProgramListingElement.this.context.resolveResources(ResourceType.JAVA, id);
            if (list.size() > 0) {
                return list.get(0).openStream();
            }
            return null;
        }
    }
}

