/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.model.content.inline;

import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.inline.InlineElement;
import org.wikbook.core.model.content.inline.LinkType;
import org.wikbook.core.xml.XMLEmitter;

public class LinkElement
extends InlineElement {
    private final LinkType type;
    private final String ref;
    private final ElementContainer<InlineElement> container = new ElementContainer<InlineElement>(InlineElement.class);

    public LinkElement(LinkType type, String ref) {
        this.type = type;
        this.ref = ref;
    }

    public boolean append(DocbookElement elt) {
        return this.container.append(elt);
    }

    public void writeTo(XMLEmitter xml) {
        switch (this.type) {
            case ANCHOR: {
                if (this.container.isNotEmpty()) {
                    this.container.writeTo(xml.element("link").withAttribute("linkend", this.ref));
                    break;
                }
                xml.element("xref").withAttribute("linkend", this.ref);
                break;
            }
            case URL: {
                if (this.ref.startsWith("mailto:")) {
                    xml.element("email").content(this.ref.substring("mailto:".length()));
                    break;
                }
                if (this.container.isNotEmpty()) {
                    this.container.writeTo(xml.element("ulink").withAttribute("url", this.ref));
                    break;
                }
                xml.element("ulink").withAttribute("url", this.ref).content(this.ref);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }
}

