/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.xml;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.wikbook.core.xml.OutputFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XML {
    public static String serialize(Document document) throws TransformerException {
        return XML.serialize(document, new OutputFormat(2, true));
    }

    public static String serialize(Document document, OutputFormat format) throws TransformerException {
        Transformer transformer = XML.createTransformer(format);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(new DOMSource(document), result);
        return writer.toString();
    }

    public static TransformerHandler createTransformerHandler(OutputFormat doctype) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        if (doctype.getIndent() != null) {
            factory.setAttribute("indent-number", doctype.getIndent());
        }
        TransformerHandler handler = factory.newTransformerHandler();
        Transformer transformer = handler.getTransformer();
        if (doctype.getIndent() != null) {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(doctype.getIndent()));
            transformer.setOutputProperty("indent", "yes");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        if (doctype.isEmitDoctype()) {
            if (doctype.getPublicId() != null) {
                transformer.setOutputProperty("doctype-public", doctype.getPublicId());
            }
            if (doctype.getSystemId() != null) {
                transformer.setOutputProperty("doctype-system", doctype.getSystemId());
            }
        }
        handler.getTransformer().setOutputProperty("omit-xml-declaration", doctype.isEmitDoctype() ? "no" : "yes");
        return handler;
    }

    public static Transformer createTransformer(OutputFormat format) throws TransformerConfigurationException {
        return XML.createTransformerHandler(format).getTransformer();
    }

    public static void removeWhiteSpace(Element elt) throws NullPointerException {
        if (elt == null) {
            throw new NullPointerException();
        }
        LinkedList<Text> childrenToRemove = null;
        NodeList children = elt.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node instanceof Text) {
                Text textChild = (Text)node;
                String trimmed = textChild.getData().trim();
                if (trimmed.length() == 0) {
                    if (childrenToRemove == null) {
                        childrenToRemove = new LinkedList<Text>();
                    }
                    childrenToRemove.add(textChild);
                    continue;
                }
                textChild.setData(trimmed);
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element eltChild = (Element)node;
            XML.removeWhiteSpace(eltChild);
        }
        if (childrenToRemove != null) {
            for (Node node : childrenToRemove) {
                elt.removeChild(node);
            }
        }
    }

    public static void copyStandaloneNodes(Node src, Node dst) {
        NodeList children = src.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() == 2) continue;
            dst.appendChild(child.cloneNode(true));
        }
    }

    public static Iterable<Element> elements(Node node) {
        NodeList children = node.getChildNodes();
        List<Element> elements = Collections.emptyList();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            if (elements.size() == 0) {
                elements = new ArrayList<Element>();
            }
            elements.add((Element)child);
        }
        return elements;
    }
}

