/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.core.render.docbook;

import java.util.HashMap;
import java.util.Map;
import org.wikbook.core.model.DocbookElement;
import org.wikbook.core.model.ElementContainer;
import org.wikbook.core.model.content.block.AdmonitionElement;
import org.wikbook.core.model.content.block.BlockElement;
import org.wikbook.core.model.content.block.BlockQuotationElement;
import org.wikbook.core.model.content.block.CalloutElement;
import org.wikbook.core.model.content.block.DOMElement;
import org.wikbook.core.model.content.block.ExampleElement;
import org.wikbook.core.model.content.block.GroupElement;
import org.wikbook.core.model.content.block.ImageElement;
import org.wikbook.core.model.content.block.ListElement;
import org.wikbook.core.model.content.block.ListItemElement;
import org.wikbook.core.model.content.block.ParagraphElement;
import org.wikbook.core.model.content.block.ProgramListingElement;
import org.wikbook.core.model.content.block.ScreenElement;
import org.wikbook.core.model.content.block.list.TermElement;
import org.wikbook.core.model.content.block.list.VariableListElement;
import org.wikbook.core.model.content.block.table.TableCellElement;
import org.wikbook.core.model.content.block.table.TableElement;
import org.wikbook.core.model.content.block.table.TableRowElement;
import org.wikbook.core.model.content.inline.AnchorElement;
import org.wikbook.core.model.content.inline.FormatElement;
import org.wikbook.core.model.content.inline.InlineImageElement;
import org.wikbook.core.model.content.inline.LinkElement;
import org.wikbook.core.model.content.inline.TextElement;
import org.wikbook.core.model.structural.BookElement;
import org.wikbook.core.model.structural.ComponentElement;
import org.wikbook.core.model.structural.PrefaceElement;
import org.wikbook.core.render.docbook.content.block.AdmonitionTransformer;
import org.wikbook.core.render.docbook.content.block.BlockQuotationTransformer;
import org.wikbook.core.render.docbook.content.block.CalloutTransformer;
import org.wikbook.core.render.docbook.content.block.DOMTransformer;
import org.wikbook.core.render.docbook.content.block.ExampleTransformer;
import org.wikbook.core.render.docbook.content.block.GroupTransformer;
import org.wikbook.core.render.docbook.content.block.ImageTransformer;
import org.wikbook.core.render.docbook.content.block.ListItemTransformer;
import org.wikbook.core.render.docbook.content.block.ListTransformer;
import org.wikbook.core.render.docbook.content.block.ParagraphTransformer;
import org.wikbook.core.render.docbook.content.block.ProgramListingTransformer;
import org.wikbook.core.render.docbook.content.block.ScreenTransformer;
import org.wikbook.core.render.docbook.content.block.list.TermTransformer;
import org.wikbook.core.render.docbook.content.block.list.VariableListTransformer;
import org.wikbook.core.render.docbook.content.block.table.TableCellTransformer;
import org.wikbook.core.render.docbook.content.block.table.TableRowTransformer;
import org.wikbook.core.render.docbook.content.block.table.TableTransformer;
import org.wikbook.core.render.docbook.content.inline.AnchorTransformer;
import org.wikbook.core.render.docbook.content.inline.FormatTransformer;
import org.wikbook.core.render.docbook.content.inline.InlineImageTransformer;
import org.wikbook.core.render.docbook.content.inline.LinkTransformer;
import org.wikbook.core.render.docbook.content.inline.TextTransformer;
import org.wikbook.core.render.docbook.structural.BookTransformer;
import org.wikbook.core.render.docbook.structural.ComponentTransformer;
import org.wikbook.core.render.docbook.structural.PrefaceTransformer;
import org.wikbook.core.xml.ElementEmitter;
import org.wikbook.core.xml.XMLEmitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementTransformer<E extends DocbookElement> {
    private static final Map<Class<? extends DocbookElement>, ElementTransformer<?>> writers = new HashMap();

    public static <E extends DocbookElement> ElementTransformer<E> getWriter(Class<E> elementType) {
        return writers.get(elementType);
    }

    public static <E extends DocbookElement> ElementTransformer<E> getWriter(E element) {
        ElementTransformer<?> writer = writers.get(element.getType());
        if (writer == null) {
            throw new IllegalArgumentException("No writer found for element " + element + " of type " + element.getType().getName());
        }
        return writer;
    }

    protected <E extends DocbookElement> void write(ElementContainer<E> container, boolean blockContainer, XMLEmitter emitter) {
        if (blockContainer) {
            ElementEmitter paraXML = null;
            for (DocbookElement e : container) {
                ElementTransformer<DocbookElement> writer = ElementTransformer.getWriter(e);
                if (e instanceof BlockElement) {
                    if (paraXML != null) {
                        paraXML = null;
                    }
                    writer.write(e, emitter);
                    continue;
                }
                if (paraXML == null) {
                    paraXML = emitter.element("para");
                }
                writer.write(e, paraXML);
            }
        } else {
            for (DocbookElement elt : container) {
                ElementTransformer<DocbookElement> writer = ElementTransformer.getWriter(elt);
                writer.write(elt, emitter);
            }
        }
    }

    public abstract void write(E var1, XMLEmitter var2);

    static {
        writers.put(BookElement.class, new BookTransformer());
        writers.put(ComponentElement.class, new ComponentTransformer());
        writers.put(PrefaceElement.class, new PrefaceTransformer());
        writers.put(AnchorElement.class, new AnchorTransformer());
        writers.put(FormatElement.class, new FormatTransformer());
        writers.put(LinkElement.class, new LinkTransformer());
        writers.put(TextElement.class, new TextTransformer());
        writers.put(InlineImageElement.class, new InlineImageTransformer());
        writers.put(AdmonitionElement.class, new AdmonitionTransformer());
        writers.put(BlockQuotationElement.class, new BlockQuotationTransformer());
        writers.put(CalloutElement.class, new CalloutTransformer());
        writers.put(DOMElement.class, new DOMTransformer());
        writers.put(ExampleElement.class, new ExampleTransformer());
        writers.put(GroupElement.class, new GroupTransformer());
        writers.put(ImageElement.class, new ImageTransformer());
        writers.put(ListItemElement.class, new ListItemTransformer());
        writers.put(ListElement.class, new ListTransformer());
        writers.put(ParagraphElement.class, new ParagraphTransformer());
        writers.put(ProgramListingElement.class, new ProgramListingTransformer());
        writers.put(ScreenElement.class, new ScreenTransformer());
        writers.put(TermElement.class, new TermTransformer());
        writers.put(VariableListElement.class, new VariableListTransformer());
        writers.put(TableElement.class, new TableTransformer());
        writers.put(TableRowElement.class, new TableRowTransformer());
        writers.put(TableCellElement.class, new TableCellTransformer());
    }
}

