/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xml;

import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.wikbook.xml.OutputFormat;

public class XML {
    public static String serialize(Document document) throws TransformerException {
        return XML.serialize(document, new OutputFormat(2, true));
    }

    public static String serialize(Document document, OutputFormat format) throws TransformerException {
        Transformer transformer = XML.createTransformer(format);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(new DOMSource(document), result);
        return writer.toString();
    }

    public static TransformerHandler createTransformerHandler(OutputFormat doctype) throws TransformerConfigurationException {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        if (doctype.getIndent() != null) {
            factory.setAttribute("indent-number", doctype.getIndent());
        }
        TransformerHandler handler = factory.newTransformerHandler();
        Transformer transformer = handler.getTransformer();
        if (doctype.getIndent() != null) {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(doctype.getIndent()));
            transformer.setOutputProperty("indent", "yes");
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        if (doctype.getPublicId() != null) {
            transformer.setOutputProperty("doctype-public", doctype.getPublicId());
        }
        if (doctype.getSystemId() != null) {
            transformer.setOutputProperty("doctype-system", doctype.getSystemId());
        }
        handler.getTransformer().setOutputProperty("omit-xml-declaration", doctype.isOmitDeclaration() ? "yes" : "no");
        return handler;
    }

    public static Transformer createTransformer(OutputFormat format) throws TransformerConfigurationException {
        return XML.createTransformerHandler(format).getTransformer();
    }
}

