/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.html2pdf;

import com.lowagie.text.DocumentException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.xhtmlrenderer.pdf.ITextRenderer;

public class Html2PdfMojo
extends AbstractMojo {
    private File sourceDirectory;
    private String sourceFileName;
    private File destinationDirectory;
    private String destinationFileName;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File document = new File(this.sourceDirectory, this.sourceFileName);
        if (!document.exists()) {
            throw new MojoFailureException("Source " + document.getAbsolutePath() + " does not exist");
        }
        if (!document.isFile()) {
            throw new MojoFailureException("Source " + document.getAbsolutePath() + " is not a valid file");
        }
        if (!this.destinationDirectory.exists()) {
            this.destinationDirectory.mkdirs();
        }
        ITextRenderer renderer = new ITextRenderer();
        try {
            renderer.setDocument(document);
        }
        catch (IOException e) {
            throw new MojoFailureException("Source " + document.getAbsolutePath() + " is not readable", (Throwable)e);
        }
        renderer.layout();
        File pdf = new File(this.destinationDirectory, this.destinationFileName);
        OutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(pdf));
            renderer.createPDF(out);
        }
        catch (FileNotFoundException e) {
            throw new MojoFailureException("Cannot write PDF", (Throwable)e);
        }
        catch (DocumentException e) {
            throw new MojoFailureException("Cannot write PDF", (Throwable)e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ignore) {}
            }
        }
    }
}

