/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.maven;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.wikbook.core.ResourceType;
import org.wikbook.core.ValidationMode;
import org.wikbook.core.xml.XML;
import org.wikbook.xwiki.AbstractXDOMDocbookBuilderContext;
import org.wikbook.xwiki.WikbookConverter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WikBookMojo
extends AbstractMojo {
    private File sourceDirectory;
    private String sourceFileName;
    private String syntaxId;
    private File destinationDirectory;
    private String destinationFileName;
    private boolean highlightCode;
    private boolean emitDoctype;
    private String validationMode;
    private String beforeBookBodyXML;
    private String afterBookBodyXML;
    private String charset;
    private MavenSession session;
    private List pluginArtifacts;
    private List<String> compileSourceRoots;
    private List<String> compileClasspathElements;
    private List<String> testCompileSourceRoots;
    private List<String> testClasspathElements;
    private final AbstractXDOMDocbookBuilderContext context = new AbstractXDOMDocbookBuilderContext(){

        public void log(String msg) {
            WikBookMojo.this.getLog().info((CharSequence)msg);
        }

        public boolean getHighlightCode() {
            return WikBookMojo.this.highlightCode;
        }

        public ValidationMode getValidationMode() {
            if ("strict".equalsIgnoreCase(WikBookMojo.this.validationMode)) {
                return ValidationMode.STRICT;
            }
            return ValidationMode.LAX;
        }

        public List<URL> resolveResources(ResourceType type, Iterable<String> path, String id) throws IOException {
            if (id.length() > 0) {
                block0 : switch (type) {
                    case WIKI: {
                        File current = WikBookMojo.this.sourceDirectory;
                        for (String segment : path) {
                            File relative = new File(current, segment);
                            if (!relative.exists()) break block0;
                            current = relative.getParentFile();
                        }
                        File resolved = new File(current, id);
                        if (resolved == null || !resolved.isFile()) break;
                        return Arrays.asList(resolved.toURI().toURL());
                    }
                    case XML: {
                        if (id.startsWith("/")) {
                            id = id.substring(1);
                        }
                    }
                    case JAVA: {
                        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
                        ArrayList dirs = new ArrayList();
                        dirs.addAll(WikBookMojo.this.compileSourceRoots);
                        dirs.addAll(WikBookMojo.this.compileClasspathElements);
                        dirs.addAll(WikBookMojo.this.testCompileSourceRoots);
                        dirs.addAll(WikBookMojo.this.testClasspathElements);
                        for (String elt : dirs) {
                            File eltFile = new File(elt);
                            if (!eltFile.exists()) continue;
                            urls.add(eltFile.toURI().toURL());
                        }
                        for (Artifact artifact : WikBookMojo.this.session.getCurrentProject().getDependencyArtifacts()) {
                            urls.add(artifact.getFile().toURI().toURL());
                        }
                        URLClassLoader cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader());
                        Enumeration<URL> found = cl.getResources(id);
                        ArrayList<URL> bilto = new ArrayList<URL>();
                        while (found.hasMoreElements()) {
                            bilto.add(found.nextElement());
                        }
                        return bilto;
                    }
                }
            }
            return Collections.emptyList();
        }

        public String getProperty(String propertyName) {
            Properties properties = WikBookMojo.this.session.getCurrentProject().getProperties();
            return properties.getProperty(propertyName);
        }

        protected String getCharsetName() {
            return WikBookMojo.this.charset;
        }
    };

    public void execute() throws MojoExecutionException, MojoFailureException {
        WikbookConverter converter;
        File src = new File(this.sourceDirectory, this.sourceFileName);
        if (!src.exists()) {
            throw new MojoFailureException("Source file " + src.getAbsolutePath() + " does not exist");
        }
        if (!src.isFile()) {
            throw new MojoFailureException("Source file " + src.getAbsolutePath() + " is not a file");
        }
        if (this.destinationDirectory.exists()) {
            if (!this.destinationDirectory.isDirectory()) {
                throw new MojoFailureException("Destination directory " + this.destinationDirectory.getAbsolutePath() + " is not a directory");
            }
        } else if (!this.destinationDirectory.mkdirs()) {
            throw new MojoFailureException("Could not create destination directory " + this.destinationDirectory.getAbsolutePath());
        }
        try {
            converter = new WikbookConverter(this.context);
        }
        catch (Exception e) {
            throw new MojoFailureException("", (Throwable)e);
        }
        converter.setEmitDoctype(this.emitDoctype);
        converter.setSyntaxId(this.syntaxId);
        File destination = new File(this.destinationDirectory, this.destinationFileName);
        OutputStreamWriter out = null;
        try {
            DocumentFragment elt;
            if (WikBookMojo.hasTrimmedContent(this.beforeBookBodyXML)) {
                elt = WikBookMojo.load(this.beforeBookBodyXML);
                converter.setBeforeBookBodyXML(elt);
            }
            if (WikBookMojo.hasTrimmedContent(this.afterBookBodyXML)) {
                elt = WikBookMojo.load(this.afterBookBodyXML);
                converter.setAfterBookBodyXML(elt);
            }
            out = new FileWriter(destination);
            StreamResult result = new StreamResult(out);
            converter.convert(this.sourceFileName, (Result)result);
        }
        catch (Exception e) {
            MojoFailureException mfe = new MojoFailureException("Could not create destination file " + e.getMessage());
            mfe.initCause((Throwable)e);
            throw mfe;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static boolean hasTrimmedContent(String xml) {
        return xml != null && xml.trim().length() > 0;
    }

    private static DocumentFragment load(String xml) throws ParserConfigurationException, IOException, SAXException {
        xml = "<root>" + xml + "</root>";
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setValidating(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(new InputSource(new StringReader(xml)));
        DocumentFragment fragment = doc.createDocumentFragment();
        XML.copyStandaloneNodes((Node)doc.getDocumentElement(), (Node)fragment);
        return fragment;
    }
}

