/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.template.processing;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.wikbook.template.freemarker.FreemarkerRenderer;
import org.wikbook.template.processing.TemplateElementVisitor;
import org.wikbook.template.processing.metamodel.MetaModel;
import org.wikbook.template.processing.metamodel.ModelContext;
import org.wikbook.template.processing.metamodel.TemplateElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTemplateProcessor
extends AbstractProcessor {
    private Class[] annotations;
    private Filer filer;
    private Elements elementsUtils;
    private Types typesUtils;
    private String templateName;
    private String generatedDirectory;
    private String ext;
    private MetaModel metaModel = new MetaModel();

    protected AbstractTemplateProcessor() {
    }

    @Override
    public boolean process(Set<? extends TypeElement> typeElements, RoundEnvironment roundEnvironment) {
        this.annotations = this.annotations();
        if (this.annotations == null) {
            throw new NullPointerException();
        }
        this.ext = this.ext();
        if (this.ext == null || this.ext.length() == 0) {
            throw new NullPointerException();
        }
        this.ext = "." + this.ext;
        this.templateName = this.templateName();
        if (this.templateName == null) {
            throw new NullPointerException();
        }
        this.generatedDirectory = this.generatedDirectory();
        if (this.generatedDirectory == null) {
            throw new NullPointerException();
        }
        if (this.annotations.length == 0) {
            return false;
        }
        ArrayList<Element> done = new ArrayList<Element>();
        this.filer = this.processingEnv.getFiler();
        this.elementsUtils = this.processingEnv.getElementUtils();
        this.typesUtils = this.processingEnv.getTypeUtils();
        ModelContext ctx = new ModelContext();
        ctx.setClasses(this.annotations);
        ctx.setElementsUtils(this.elementsUtils);
        ctx.setTypesUtils(this.typesUtils);
        for (Class clazz : this.annotations) {
            Set<? extends Element> elements = roundEnvironment.getElementsAnnotatedWith(clazz);
            for (Element element : elements) {
                if (done.contains(element)) continue;
                switch (element.getKind()) {
                    case CLASS: 
                    case PACKAGE: {
                        List<TemplateElement> built = this.buildElements(element, ctx);
                        this.metaModel.addAll(built);
                    }
                }
                done.add(element);
            }
        }
        if (roundEnvironment.processingOver()) {
            String fileName = null;
            for (TemplateElement el : this.metaModel.getElements()) {
                try {
                    fileName = el.getType() != null ? el.getType().getFqn() : el.getName();
                    FileObject file = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, this.generatedDirectory, "" + fileName + this.ext, null);
                    OutputStream os = file.openOutputStream();
                    new FreemarkerRenderer().render(this.metaModel, this.templateName, el, os, this.filer);
                    if (!this.writeModel()) continue;
                    this.writeState(this.metaModel, fileName + this.ext);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return false;
    }

    private List<TemplateElement> buildElements(Element el, ModelContext ctx) {
        TemplateElementVisitor visitor = new TemplateElementVisitor();
        List<TemplateElement> elements = el.accept(visitor, ctx);
        return elements;
    }

    private void writeState(MetaModel metaModel, String name) {
        try {
            FileObject servicesfile = this.filer.createResource(StandardLocation.SOURCE_OUTPUT, this.generatedDirectory, name + ".model", null);
            ObjectOutputStream oos = new ObjectOutputStream(servicesfile.openOutputStream());
            oos.writeObject(metaModel);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean writeModel() {
        return false;
    }

    protected abstract Class[] annotations();

    protected abstract String templateName();

    protected abstract String generatedDirectory();

    protected abstract String ext();
}

