/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.template.freemarker.caller;

import freemarker.template.SimpleScalar;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.wikbook.template.freemarker.FreemarkerDataFactory;
import org.wikbook.template.freemarker.TemplateExpression;
import org.wikbook.template.processing.metamodel.TemplateAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeCallerMethod
implements TemplateMethodModel {
    private Map<String, Object> attributes;
    private FreemarkerDataFactory dataFactory;

    public AttributeCallerMethod(FreemarkerDataFactory dataFactory, Map<String, Object> attributes) {
        this.attributes = attributes;
        this.dataFactory = dataFactory;
    }

    public Object exec(List arguments) throws TemplateModelException {
        TemplateExpression e = new TemplateExpression((String)arguments.get(0));
        Object got = this.attributes.get(e.getValue());
        if (got != null) {
            Class<?> valuesClass = got.getClass();
            if (valuesClass.isArray()) {
                if (TemplateAnnotation.class.equals(valuesClass.getComponentType())) {
                    ArrayList<Map<String, Object>> l = new ArrayList<Map<String, Object>>();
                    for (TemplateAnnotation annotation : (TemplateAnnotation[])got) {
                        l.add(this.dataFactory.create(annotation));
                    }
                    return l;
                }
                return this.performArray(Arrays.asList((String[])got), e);
            }
            if (got instanceof TemplateAnnotation) {
                return this.dataFactory.create((TemplateAnnotation)got);
            }
            return new SimpleScalar(got.toString());
        }
        return null;
    }

    private Object performArray(List<String> data, TemplateExpression e) {
        switch (e.getOutput()) {
            case LIST: 
            case NONE: {
                return data;
            }
            case FLAT: 
            case BLOC: 
            case NOEXPR: {
                return e.flatStringList(data);
            }
        }
        if (e.getOutput().equals((Object)TemplateExpression.Output.LIST)) {
            return Collections.emptyList();
        }
        return "";
    }
}

