/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.template.processing;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.wikbook.template.processing.ProcessingUtils;
import org.wikbook.template.processing.metamodel.ModelContext;
import org.wikbook.template.processing.metamodel.TemplateAnnotation;
import org.wikbook.template.processing.metamodel.TemplateElement;
import org.wikbook.template.processing.metamodel.TemplateType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateElementVisitor
implements ElementVisitor<List<TemplateElement>, ModelContext> {
    @Override
    public List<TemplateElement> visit(Element element, ModelContext ctx) {
        return null;
    }

    @Override
    public List<TemplateElement> visit(Element element) {
        return null;
    }

    @Override
    public List<TemplateElement> visitPackage(PackageElement packageElement, ModelContext ctx) {
        ArrayList<TemplateElement> elements = new ArrayList<TemplateElement>();
        TemplateElement pkgTmplElement = new TemplateElement(packageElement.getQualifiedName().toString());
        this.applyDoc(packageElement, pkgTmplElement, ctx);
        for (Class clazz : ctx.getAnnotations()) {
            Object a = packageElement.getAnnotation(clazz);
            if (a == null) continue;
            TemplateAnnotation annotation = ProcessingUtils.createAnnotation(a, pkgTmplElement);
            pkgTmplElement.addAnnotation(annotation);
            if (!elements.contains(pkgTmplElement)) {
                elements.add(pkgTmplElement);
            }
            for (Element element : packageElement.getEnclosedElements()) {
                for (TemplateElement te : element.accept(this, ctx)) {
                    pkgTmplElement.addElement(te);
                }
            }
        }
        return elements;
    }

    @Override
    public List<TemplateElement> visitType(TypeElement typeElement, ModelContext ctx) {
        TypeMirror paramType = typeElement.asType();
        TemplateType type = this.buildTemplateType(paramType, ctx);
        TemplateElement classElement = new TemplateElement(typeElement.getSimpleName().toString(), type);
        this.applyDoc(typeElement, classElement, ctx);
        if (ctx == null) {
            throw new NullPointerException();
        }
        ArrayList<TemplateElement> elements = new ArrayList<TemplateElement>();
        ctx.setTypeElement(classElement);
        for (Class clazz : ctx.getAnnotations()) {
            Object a = typeElement.getAnnotation(clazz);
            if (a == null) continue;
            TemplateAnnotation annotation = ProcessingUtils.createAnnotation(a, classElement);
            classElement.addAnnotation(annotation);
            if (!elements.contains(classElement)) {
                elements.add(classElement);
            }
            for (Element element : typeElement.getEnclosedElements()) {
                if (!element.getKind().equals((Object)ElementKind.METHOD)) continue;
                element.accept(this, ctx);
            }
        }
        return elements;
    }

    @Override
    public List<TemplateElement> visitVariable(VariableElement variableElement, ModelContext ctx) {
        TypeMirror paramType = variableElement.asType();
        TemplateType type = this.buildTemplateType(paramType, ctx);
        TemplateElement paramElement = new TemplateElement(variableElement.getSimpleName().toString(), type);
        TemplateElement methodElement = ctx.getExecutableElement();
        for (Class clazz : ctx.getAnnotations()) {
            Object a = variableElement.getAnnotation(clazz);
            TemplateAnnotation annotation = ProcessingUtils.createAnnotation(a, paramElement);
            if (annotation == null) continue;
            for (String key : methodElement.getJavadoc().keySet()) {
                if (!"param".equals(key)) continue;
                List<List<String>> paramsDoc = methodElement.getJavadoc().get(key);
                this.docParam(annotation, variableElement, paramsDoc);
            }
            paramElement.addAnnotation(annotation);
            if (methodElement.getElements().contains(paramElement)) continue;
            methodElement.addElement(paramElement);
        }
        return null;
    }

    @Override
    public List<TemplateElement> visitExecutable(ExecutableElement executableElement, ModelContext ctx) {
        TypeMirror returnType = executableElement.getReturnType();
        TemplateType type = this.buildTemplateType(returnType, ctx);
        String executableName = executableElement.getSimpleName().toString();
        TemplateElement methodElement = new TemplateElement(executableName, type);
        TemplateElement typeElement = ctx.getTypeElement();
        this.applyDoc(executableElement, methodElement, ctx);
        for (Class clazz : ctx.getAnnotations()) {
            Object a = executableElement.getAnnotation(clazz);
            TemplateAnnotation annotation = ProcessingUtils.createAnnotation(a, methodElement);
            if (annotation == null) continue;
            methodElement.addAnnotation(annotation);
            if (typeElement.getElements().contains(methodElement)) continue;
            typeElement.addElement(methodElement);
            ctx.setExecutableElement(methodElement);
            for (VariableElement variableElement : executableElement.getParameters()) {
                variableElement.accept(this, ctx);
            }
        }
        return null;
    }

    @Override
    public List<TemplateElement> visitTypeParameter(TypeParameterElement typeParameterElement, ModelContext ctx) {
        return null;
    }

    @Override
    public List<TemplateElement> visitUnknown(Element element, ModelContext ctx) {
        return null;
    }

    private void doc(TemplateElement tel, String name, List<String> l) {
        if (name == null) {
            tel.getJavadoc(null).add(new ArrayList<String>(l));
        } else {
            if (l.size() == 0) {
                l.add(name.substring(1));
            }
            tel.getJavadoc(name.substring(1)).add(new ArrayList<String>(l));
        }
        l.clear();
    }

    private void applyDoc(Element el, TemplateElement tel, ModelContext ctx) {
        String documentation = ctx.getElementsUtils().getDocComment(el);
        if (documentation == null) {
            return;
        }
        BufferedReader br = new BufferedReader(new StringReader(documentation));
        String currentName = null;
        ArrayList<String> l = new ArrayList<String>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = this.cleanLeft(line)).startsWith("@")) {
                    this.doc(tel, currentName, l);
                    int delimiterPos = line.indexOf(" ");
                    if (delimiterPos != -1) {
                        currentName = line.substring(0, delimiterPos);
                        l.add(line.substring(delimiterPos + 1));
                        continue;
                    }
                    currentName = line;
                    continue;
                }
                l.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.doc(tel, currentName, l);
    }

    private void docParam(TemplateAnnotation annotation, VariableElement variableElement, List<List<String>> paramsDoc) {
        for (List<String> docValue : paramsDoc) {
            if (docValue.size() <= 0) continue;
            String elementName = variableElement.getSimpleName().toString();
            if (!docValue.get(0).startsWith(elementName)) continue;
            int pos = elementName.length() + 1;
            if (pos < docValue.get(0).length()) {
                docValue.set(0, docValue.get(0).substring(pos));
                annotation.getJavadoc(null).add(docValue);
                continue;
            }
            annotation.getJavadoc(null).add(new ArrayList());
        }
    }

    private TemplateType buildTemplateType(TypeMirror typeMirror, ModelContext ctx) {
        switch (typeMirror.getKind()) {
            case ARRAY: {
                ArrayType arrayType = (ArrayType)typeMirror;
                DeclaredType componentDeclaredType = (DeclaredType)arrayType.getComponentType();
                TemplateType templateType = this.buildTemplateType(componentDeclaredType, ctx);
                return new TemplateType(templateType.getName(), templateType.getFqn(), true, templateType.getParameters());
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)typeMirror;
                TypeElement declaredTypeElement = (TypeElement)declaredType.asElement();
                ArrayList<TemplateType> typeParameters = new ArrayList<TemplateType>();
                for (TypeMirror typeMirror2 : declaredType.getTypeArguments()) {
                    typeParameters.add(this.buildTemplateType(typeMirror2, ctx));
                }
                return new TemplateType(declaredTypeElement.getSimpleName().toString(), declaredTypeElement.getQualifiedName().toString(), false, typeParameters.toArray(new TemplateType[0]));
            }
        }
        return new TemplateType("", "", false, new TemplateType[0]);
    }

    private String cleanLeft(String newJavadocEntry) {
        block4: for (int i = 0; i < newJavadocEntry.length(); ++i) {
            switch (newJavadocEntry.charAt(i)) {
                case ' ': {
                    continue block4;
                }
                case '@': {
                    return newJavadocEntry.substring(i);
                }
                default: {
                    return newJavadocEntry;
                }
            }
        }
        return "";
    }
}

