/*
 * Decompiled with CFR 0.152.
 */
package org.wikbook.xwiki;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PropertyFilter {
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\[(\\w[\\w\\.]*)\\]");

    protected abstract String resolveProperty(String var1);

    public String filter(String s) {
        Matcher matcher = PROPERTY_PATTERN.matcher(s);
        StringBuilder builder = new StringBuilder();
        int pre = 0;
        while (matcher.find()) {
            builder.append(s, pre, matcher.start());
            String propertyName = matcher.group(1);
            String propertyValue = this.resolveProperty(propertyName);
            if (propertyValue != null) {
                builder.append(propertyValue);
            } else {
                builder.append("$[").append(propertyName).append("]");
            }
            pre = matcher.end();
        }
        builder.append(s, pre, s.length());
        return builder.toString();
    }
}

