/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.wikimodel.wem.IWemConstants;
import org.wikimodel.wem.WikiPageUtil;
import org.wikimodel.wem.WikiParameter;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;
import org.wikimodel.wem.impl.WikiScannerContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XhtmlHandler
extends DefaultHandler {
    protected String fDocumentSectionUri;
    protected String fDocumentUri;
    protected String fDocumentWikiProperties;
    TagStack fStack;
    private StringBuffer accumulationBuffer;

    public XhtmlHandler(WikiScannerContext context) {
        this.fStack = new TagStack(context);
    }

    public void characters(char[] array, int start, int length) throws SAXException {
        if (this.accumulationBuffer != null) {
            this.accumulationBuffer.append(array, start, length);
        }
    }

    public void endDocument() throws SAXException {
        this.fStack.endElement();
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.accumulationBuffer != null && this.accumulationBuffer.length() > 0) {
            this.fStack.onCharacters(this.accumulationBuffer.toString().toCharArray(), 0, this.accumulationBuffer.length());
            this.accumulationBuffer.setLength(0);
        }
        this.fStack.endElement();
    }

    protected String getHref(Attributes attributes) {
        String value = attributes.getValue("HREF");
        if (value == null) {
            value = attributes.getValue("href");
        }
        if (value == null) {
            value = attributes.getValue("src");
        }
        if (value == null) {
            value = attributes.getValue("SRC");
        }
        return value;
    }

    public void startDocument() throws SAXException {
        this.fStack.beginElement(null, null, null, null);
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.accumulationBuffer != null && this.accumulationBuffer.length() > 0) {
            this.fStack.onCharacters(this.accumulationBuffer.toString().toCharArray(), 0, this.accumulationBuffer.length());
        }
        this.accumulationBuffer = new StringBuffer();
        this.fStack.beginElement(uri, localName, qName, attributes);
    }

    public static void sendEmptyLines(TagStack.TagContext context) {
        Object linesCountObject = TagStack.getStackParameter("emptyLinesCount");
        if (linesCountObject != null && (Integer)linesCountObject > 0) {
            context.getScannerContext().onEmptyLines((Integer)linesCountObject - 1);
            TagStack.setStackParameter("emptyLinesCount", null);
        }
    }

    static {
        TagStack.add("p", new TagHandler(false, true, true){

            protected void begin(TagStack.TagContext context) {
                XhtmlHandler.sendEmptyLines(context);
                context.getScannerContext().beginParagraph(context.getParams());
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endParagraph();
            }
        });
        TagStack.add("table", new TagHandler(false, true, false){

            protected void begin(TagStack.TagContext context) {
                XhtmlHandler.sendEmptyLines(context);
                context.getScannerContext().beginTable(context.getParams());
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endTable();
            }
        });
        TagStack.add("tr", new TagHandler(false, false, false){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().beginTableRow(false);
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endTableRow();
            }
        });
        TagHandler handler = new TagHandler(true, false, true){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().beginTableCell(context.isTag("th"));
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endTableCell();
            }
        };
        TagStack.add("td", handler);
        TagStack.add("th", handler);
        handler = new TagHandler(false, true, false){

            protected void begin(TagStack.TagContext context) {
                XhtmlHandler.sendEmptyLines(context);
                context.getScannerContext().beginList();
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endList();
            }
        };
        TagStack.add("ul", handler);
        TagStack.add("ol", handler);
        TagStack.add("li", new TagHandler(true, false, true){

            public void begin(TagStack.TagContext context) {
                String markup = context.getParent().getName().equals("ol") ? "#" : "*";
                context.getScannerContext().beginListItem(markup);
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endListItem();
            }
        });
        TagStack.add("dl", new TagHandler(false, true, false){

            protected void begin(TagStack.TagContext context) {
                XhtmlHandler.sendEmptyLines(context);
                context.getScannerContext().beginList();
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endList();
            }
        });
        TagStack.add("dt", new TagHandler(false, false, true){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().beginListItem(";");
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endListItem();
            }
        });
        TagStack.add("dd", new TagHandler(true, false, true){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().beginListItem(":");
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endListItem();
            }
        });
        handler = new TagHandler(false, true, true){

            protected void begin(TagStack.TagContext context) {
                String tag = context.getName();
                int level = Integer.parseInt(tag.substring(1, 2));
                XhtmlHandler.sendEmptyLines(context);
                context.getScannerContext().beginHeader(level);
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().endHeader();
            }
        };
        TagStack.add("h1", handler);
        TagStack.add("h2", handler);
        TagStack.add("h3", handler);
        TagStack.add("h4", handler);
        TagStack.add("h5", handler);
        TagStack.add("h6", handler);
        TagStack.add("hr", new TagHandler(false, true, false){

            protected void begin(TagStack.TagContext context) {
                XhtmlHandler.sendEmptyLines(context);
                context.getScannerContext().onHorizontalLine();
            }
        });
        TagStack.add("pre", new TagHandler(false, true, true){
            {
                this.fAccumulateContent = true;
            }

            protected void end(TagStack.TagContext context) {
                String str = context.getContent();
                XhtmlHandler.sendEmptyLines(context);
                context.getScannerContext().onVerbatim(str, false);
            }
        });
        TagStack.add("a", new TagHandler(false, false, true){
            {
                this.fAccumulateContent = true;
            }

            protected void begin(TagStack.TagContext context) {
            }

            protected void end(TagStack.TagContext context) {
                WikiParameter ref = context.getParams().getParameter("href");
                if (ref != null) {
                    String content = context.getContent();
                    WikiReference reference = new WikiReference(ref.getValue(), content);
                    context.getScannerContext().onReference(reference);
                }
            }
        });
        handler = new TagHandler(false, false, true){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.STRONG);
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.STRONG);
            }
        };
        TagStack.add("strong", handler);
        TagStack.add("b", handler);
        handler = new TagHandler(false, false, true){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.INS);
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.INS);
            }
        };
        TagStack.add("u", handler);
        TagStack.add("ins", handler);
        handler = new TagHandler(false, false, true){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.STRIKE);
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.STRIKE);
            }
        };
        TagStack.add("del", handler);
        TagStack.add("s", handler);
        TagStack.add("strike", handler);
        handler = new TagHandler(false, false, true){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.EM);
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.EM);
            }
        };
        TagStack.add("em", handler);
        TagStack.add("i", handler);
        handler = new TagHandler(false, false, true){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.SUP);
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.SUP);
            }
        };
        TagStack.add("sup", handler);
        handler = new TagHandler(false, false, true){

            protected void begin(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.SUB);
            }

            protected void end(TagStack.TagContext context) {
                context.getScannerContext().onFormat(IWemConstants.SUB);
            }
        };
        TagStack.add("sub", handler);
        TagStack.add("tt", new TagHandler(false, false, true){

            protected void begin(TagStack.TagContext context) {
                String classValue = context.fAttributes.getValue("class");
                if (classValue != null && classValue.equalsIgnoreCase("wikimodel-verbatim")) {
                    this.fAccumulateContent = true;
                } else {
                    context.getScannerContext().onFormat(IWemConstants.MONO);
                }
            }

            protected void end(TagStack.TagContext context) {
                String classValue = context.fAttributes.getValue("class");
                if (classValue != null && classValue.equalsIgnoreCase("wikimodel-verbatim")) {
                    String str = context.getContent();
                    context.getScannerContext().onVerbatim(str, true);
                } else {
                    context.getScannerContext().onFormat(IWemConstants.MONO);
                }
            }
        });
        TagStack.add("br", new TagHandler(false, false, false){

            protected void begin(TagStack.TagContext context) {
                if (context.getParent() == null || context.getParent().isTag("html") || context.getParent().isTag("body")) {
                    int value = 0;
                    if (TagStack.getStackParameter("emptyLinesCount") != null) {
                        value = (Integer)TagStack.getStackParameter("emptyLinesCount");
                    }
                    TagStack.setStackParameter("emptyLinesCount", ++value);
                } else {
                    context.getScannerContext().onLineBreak();
                }
            }
        });
    }

    protected static class TagStack {
        private static final int CHARACTER = 0;
        private static Map<String, TagHandler> fMap = new HashMap<String, TagHandler>();
        private static final int NEW_LINE = 3;
        private static final char SPACE = '\u0001';
        private static final int SPECIAL_SYMBOL = 2;
        private static Map<String, Object> fStackParameters = new HashMap<String, Object>();
        private TagContext fPeek;
        WikiScannerContext fScannerContext;

        public static void add(String tag, TagHandler handler) {
            fMap.put(tag, handler);
        }

        public TagStack(WikiScannerContext context) {
            this.fScannerContext = context;
        }

        public void beginElement(String uri, String localName, String qName, Attributes attributes) {
            this.fPeek = new TagContext(this.fPeek, uri, localName, qName, attributes);
            localName = this.fPeek.getName();
            TagHandler handler = fMap.get(localName);
            this.fPeek.beginElement(handler);
        }

        public void endElement() {
            this.fPeek.endElement();
            this.fPeek = this.fPeek.fParent;
        }

        private void flushBuffer(StringBuffer buf, int type) {
            if (buf.length() > 0) {
                String str = buf.toString();
                switch (type) {
                    case 1: {
                        this.fScannerContext.onSpace(str);
                        break;
                    }
                    case 2: {
                        this.fScannerContext.onSpecialSymbol(str);
                        break;
                    }
                    case 0: {
                        str = WikiPageUtil.escapeXmlString(str);
                        this.fScannerContext.onWord(str);
                        break;
                    }
                    case 3: {
                        this.fScannerContext.onNewLine();
                    }
                }
            }
            buf.delete(0, buf.length());
        }

        private int getCharacterType(char ch) {
            int type = 0;
            switch (ch) {
                case '!': 
                case '\"': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '<': 
                case '=': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '_': 
                case '`': 
                case '{': 
                case '|': 
                case '}': 
                case '~': {
                    type = 2;
                    break;
                }
                case '\t': 
                case ' ': {
                    type = 1;
                    break;
                }
                case '\n': 
                case '\r': {
                    type = 3;
                    break;
                }
                default: {
                    type = 0;
                }
            }
            return type;
        }

        public WikiScannerContext getScannerContext() {
            return this.fScannerContext;
        }

        public void onCharacters(char[] array, int start, int length) {
            if (!this.fPeek.isContentContainer()) {
                return;
            }
            if (!this.fPeek.appendContent(array, start, length)) {
                StringBuffer buf = new StringBuffer();
                int type = 0;
                for (int i = 0; i < length; ++i) {
                    char ch = array[start + i];
                    int oldType = type;
                    type = this.getCharacterType(ch);
                    if (type != oldType || oldType == 2) {
                        this.flushBuffer(buf, oldType);
                    }
                    buf.append(ch);
                }
                this.flushBuffer(buf, type);
            }
        }

        public static void setStackParameter(String name, Object data) {
            fStackParameters.put(name, data);
        }

        public static Object getStackParameter(String name) {
            return fStackParameters.get(name);
        }

        public class TagContext {
            private final Attributes fAttributes;
            private StringBuffer fContent;
            public TagHandler fHandler;
            String fLocalName;
            private final TagContext fParent;
            String fQName;
            String fUri;

            public TagContext(TagContext parent, String uri, String localName, String qName, Attributes attributes) {
                this.fUri = uri;
                this.fLocalName = localName;
                this.fQName = qName;
                this.fParent = parent;
                this.fAttributes = attributes;
            }

            public boolean appendContent(char[] array, int start, int length) {
                if (this.fHandler == null || !this.fHandler.fAccumulateContent) {
                    return false;
                }
                if (this.fContent == null) {
                    this.fContent = new StringBuffer();
                }
                this.fContent.append(array, start, length);
                return true;
            }

            public void beginElement(TagHandler handler) {
                if (this.fParent == null) {
                    TagStack.this.fScannerContext.beginDocument();
                }
                this.fHandler = handler;
                if (this.fHandler != null) {
                    this.fHandler.beginElement(this);
                }
            }

            public void endElement() {
                if (this.fHandler != null) {
                    this.fHandler.endElement(this);
                }
                if (this.fParent == null) {
                    TagStack.this.fScannerContext.endDocument();
                }
            }

            public String getContent() {
                return this.fContent != null ? WikiPageUtil.escapeXmlString(this.fContent.toString()) : "";
            }

            public String getLocalName() {
                return this.fLocalName;
            }

            private String getLocalName(String uri, String localName, String name, boolean upperCase) {
                String result = localName != null && !"".equals(localName) ? localName : name;
                return upperCase ? result.toUpperCase() : result;
            }

            public String getName() {
                return this.getLocalName(this.fUri, this.fLocalName, this.fQName, false);
            }

            public WikiParameters getParams() {
                ArrayList<WikiParameter> list = new ArrayList<WikiParameter>();
                int len = this.fAttributes != null ? this.fAttributes.getLength() : 0;
                for (int i = 0; i < len; ++i) {
                    String key = this.getLocalName(this.fAttributes.getURI(i), this.fAttributes.getQName(i), this.fAttributes.getLocalName(i), false);
                    String value = this.fAttributes.getValue(i);
                    WikiParameter param = new WikiParameter(key, value);
                    list.add(param);
                }
                WikiParameters params = new WikiParameters(list);
                return params;
            }

            public TagContext getParent() {
                return this.fParent;
            }

            public String getQName() {
                return this.fQName;
            }

            public WikiScannerContext getScannerContext() {
                return TagStack.this.fScannerContext;
            }

            public String getUri() {
                return this.fUri;
            }

            public boolean isContentContainer() {
                return this.fHandler == null || this.fHandler.isContentContainer();
            }

            public boolean isTag(String string) {
                return string.equals(this.fLocalName.toLowerCase());
            }
        }
    }

    public static class TagHandler {
        public boolean fAccumulateContent;
        private final boolean fContentContainer;
        private final boolean fDocumentContainer;
        private final boolean fRequiresDocument;

        private static boolean requiresParentDocument(TagStack.TagContext context) {
            if (context == null) {
                return true;
            }
            if (context.fHandler == null || !context.fHandler.requiresDocument()) {
                return false;
            }
            boolean inContainer = false;
            TagStack.TagContext parent = context.fParent;
            while (parent != null) {
                if (parent.fHandler != null) {
                    inContainer = parent.fHandler.isDocumentContainer();
                    break;
                }
                parent = parent.fParent;
            }
            return inContainer;
        }

        public TagHandler(boolean documentContainer, boolean requiresDocument, boolean contentContainer) {
            this.fDocumentContainer = documentContainer;
            this.fRequiresDocument = requiresDocument;
            this.fContentContainer = contentContainer;
        }

        protected void begin(TagStack.TagContext context) {
        }

        public void beginElement(TagStack.TagContext context) {
            if (TagHandler.requiresParentDocument(context)) {
                context.getScannerContext().endDocument();
            }
            this.begin(context);
        }

        protected void end(TagStack.TagContext context) {
        }

        public final void endElement(TagStack.TagContext context) {
            if (TagHandler.requiresParentDocument(context)) {
                context.getScannerContext().endDocument();
            }
            this.end(context);
        }

        public boolean isContentContainer() {
            return this.fContentContainer;
        }

        public boolean isDocumentContainer() {
            return this.fDocumentContainer;
        }

        public boolean requiresDocument() {
            return this.fRequiresDocument;
        }
    }
}

