/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem;

import java.util.HashSet;
import java.util.Set;
import org.wikimodel.wem.WikiStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WikiFormat {
    public static WikiFormat EMPTY = new WikiFormat();
    private String fClosingTags;
    private String fOpeningTags;
    private Set<WikiStyle> fStyles = new HashSet<WikiStyle>();

    public WikiFormat() {
    }

    public WikiFormat(Set<WikiStyle> styles) {
        this.fStyles.addAll(styles);
    }

    public WikiFormat(WikiStyle style) {
        this.fStyles.add(style);
    }

    public WikiFormat(WikiStyle[] styles) {
        for (WikiStyle style : styles) {
            this.fStyles.add(style);
        }
    }

    public WikiFormat addStyle(WikiStyle style) {
        if (this.fStyles.contains(style)) {
            return this;
        }
        WikiFormat clone = this.getClone();
        clone.fStyles.add(style);
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WikiFormat)) {
            return false;
        }
        WikiFormat set = (WikiFormat)obj;
        return ((Object)this.fStyles).equals(set.fStyles);
    }

    protected WikiFormat getClone() {
        return new WikiFormat(this.fStyles);
    }

    public String getTags(boolean open) {
        if (this.fOpeningTags == null) {
            StringBuffer o = new StringBuffer();
            StringBuffer c = new StringBuffer();
            for (WikiStyle style : this.fStyles) {
                o.append("<").append(style).append(">");
                c.insert(0, ">").insert(0, style).insert(0, "</");
            }
            this.fOpeningTags = o.toString().intern();
            this.fClosingTags = c.toString().intern();
        }
        return open ? this.fOpeningTags : this.fClosingTags;
    }

    public int hashCode() {
        return ((Object)this.fStyles).hashCode();
    }

    public boolean hasStyle(WikiStyle style) {
        return this.fStyles.contains(style);
    }

    public WikiFormat removeStyle(WikiStyle style) {
        if (!this.fStyles.contains(style)) {
            return this;
        }
        WikiFormat clone = this.getClone();
        clone.fStyles.remove(style);
        return clone;
    }

    public WikiFormat switchStyle(WikiStyle wikiStyle) {
        WikiFormat clone = this.getClone();
        if (clone.fStyles.contains(wikiStyle)) {
            clone.fStyles.remove(wikiStyle);
        } else {
            clone.fStyles.add(wikiStyle);
        }
        return clone;
    }

    public String toString() {
        return this.fStyles.toString();
    }
}

