/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml;

import java.io.Reader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.wikimodel.wem.IWemListener;
import org.wikimodel.wem.IWikiParser;
import org.wikimodel.wem.WikiParserException;
import org.wikimodel.wem.impl.WikiScannerContext;
import org.wikimodel.wem.xhtml.XhtmlEscapeHandler;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XhtmlParser
implements IWikiParser {
    private XhtmlEscapeHandler fEscapeHandler;

    public XhtmlParser() {
        this(null);
    }

    public XhtmlParser(XhtmlEscapeHandler escapeHandler) {
        this.fEscapeHandler = escapeHandler;
    }

    public DefaultHandler getHandler(IWemListener listener) {
        WikiScannerContext context = new WikiScannerContext(listener);
        XhtmlHandler handler = new XhtmlHandler(context, this.fEscapeHandler);
        return handler;
    }

    public void parse(Reader reader, IWemListener listener) throws WikiParserException {
        try {
            SAXParserFactory parserFactory = SAXParserFactory.newInstance();
            SAXParser parser = parserFactory.newSAXParser();
            XMLReader xmlReader = parser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            DefaultHandler handler = this.getHandler(listener);
            xmlReader.setContentHandler(handler);
            InputSource source = new InputSource(reader);
            xmlReader.parse(source);
        }
        catch (Exception e) {
            throw new WikiParserException(e);
        }
    }
}

