/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml.filter;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wikimodel.wem.xhtml.filter.DefaultXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XHTMLWhitespaceXMLFilter
extends DefaultXMLFilter {
    private static final Pattern HTML_WHITESPACE_DUPLICATES_PATTERN = Pattern.compile("\\s{2,}|[\\t\\n\\x0B\\f\\r]+");
    private static final Pattern HTML_WHITESPACE_HEAD_PATTERN = Pattern.compile("^\\s+");
    private static final Pattern HTML_WHITESPACE_TAIL_PATTERN = Pattern.compile("\\s+$");
    private static final List<String> BLOCK_ELEMENTS = Arrays.asList("p", "table", "ul", "ol", "li", "hr", "td", "tr", "th", "div", "tbody", "thead", "pre", "h1", "h2", "h3", "h4", "h5", "h6", "dl", "dt", "dd", "blockquote");
    private boolean fRemoveWhitespaces = true;
    private String fLastClosedElement;
    private String fStartedElement;
    private StringBuffer fContent = new StringBuffer();
    private StringBuffer fContentBeforeComment;

    public XHTMLWhitespaceXMLFilter() {
    }

    public XHTMLWhitespaceXMLFilter(XMLReader reader) {
        super(reader);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.getContent().append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.cleanWhiteSpacesBeforeElement();
        this.cleanExtraWhiteSpaces();
        if (this.getContent().length() == 1 && this.getContent().charAt(0) == ' ' && this.fLastClosedElement != null && BLOCK_ELEMENTS.contains(this.fLastClosedElement) && BLOCK_ELEMENTS.contains(localName)) {
            this.getContent().setLength(0);
        } else {
            this.sendCharacters();
        }
        this.fLastClosedElement = null;
        this.fContentBeforeComment = null;
        this.fStartedElement = localName;
        super.startElement(uri, localName, qName, atts);
        if ("pre".equalsIgnoreCase(localName)) {
            this.fRemoveWhitespaces = false;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.cleanWhiteSpacesAfterElement(localName);
        this.cleanExtraWhiteSpaces();
        this.sendCharacters();
        this.fLastClosedElement = localName;
        this.fStartedElement = null;
        this.fRemoveWhitespaces = true;
        this.fContentBeforeComment = null;
        super.endElement(uri, localName, qName);
    }

    public void startCDATA() throws SAXException {
        this.cleanWhiteSpacesBeforeElement();
        this.cleanExtraWhiteSpaces();
        this.sendCharacters();
        this.fRemoveWhitespaces = false;
        this.fContentBeforeComment = null;
        super.startCDATA();
    }

    public void endCDATA() throws SAXException {
        if (this.getContent().length() > 0) {
            this.sendCharacters();
        }
        super.endCDATA();
        this.fRemoveWhitespaces = true;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.isSemanticComment(new String(ch, start, length))) {
            this.cleanWhiteSpacesAfterElement(this.fStartedElement);
            this.cleanExtraWhiteSpaces();
            this.fContentBeforeComment = new StringBuffer(this.fContent);
        } else {
            this.fStartedElement = "semanticcomment";
            this.cleanExtraWhiteSpaces();
        }
        this.sendCharacters();
        super.comment(ch, start, length);
    }

    protected boolean shouldRemoveWhiteSpaces() {
        return this.fRemoveWhitespaces;
    }

    protected void sendCharacters() throws SAXException {
        if (this.getContent().length() > 0) {
            super.characters(this.getContent().toString().toCharArray(), 0, this.getContent().length());
            this.getContent().setLength(0);
        }
    }

    private void cleanWhiteSpacesBeforeElement() throws SAXException {
        if (!(this.getContent().length() <= 0 || this.fStartedElement == null || this.fStartedElement.equalsIgnoreCase("semanticcomment") || this.fContentBeforeComment != null && this.fContentBeforeComment.length() != 0)) {
            this.trimLeadingWhiteSpaces();
        }
    }

    private void cleanWhiteSpacesAfterElement(String tagName) throws SAXException {
        if (this.getContent().length() > 0) {
            if (this.fStartedElement == null) {
                this.trimTrailingWhiteSpaces();
            } else if (this.fStartedElement.equalsIgnoreCase(tagName)) {
                if (this.fContentBeforeComment == null || this.fContentBeforeComment.length() == 0) {
                    this.trimLeadingWhiteSpaces();
                }
                this.trimTrailingWhiteSpaces();
            } else if (this.fStartedElement.equalsIgnoreCase("semanticcomment")) {
                this.trimTrailingWhiteSpaces();
            }
        }
    }

    protected void cleanExtraWhiteSpaces() {
        if (this.getContent().length() > 0 && this.shouldRemoveWhiteSpaces()) {
            Matcher matcher = HTML_WHITESPACE_DUPLICATES_PATTERN.matcher(this.getContent());
            String result = matcher.replaceAll(" ");
            this.getContent().setLength(0);
            this.getContent().append(result);
        }
    }

    protected void trimLeadingWhiteSpaces() {
        if (this.shouldRemoveWhiteSpaces()) {
            Matcher matcher = HTML_WHITESPACE_HEAD_PATTERN.matcher(this.getContent());
            String result = matcher.replaceAll("");
            this.getContent().setLength(0);
            this.getContent().append(result);
        }
    }

    protected void trimTrailingWhiteSpaces() {
        if (this.shouldRemoveWhiteSpaces()) {
            Matcher matcher = HTML_WHITESPACE_TAIL_PATTERN.matcher(this.getContent());
            String result = matcher.replaceAll("");
            this.getContent().setLength(0);
            this.getContent().append(result);
        }
    }

    protected StringBuffer getContent() {
        return this.fContent;
    }

    protected boolean isSemanticComment(String comment) {
        return comment.startsWith("startmacro:") || comment.startsWith("stopmacro");
    }
}

