/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml;

import org.wikimodel.wem.IWikiPrinter;
import org.wikimodel.wem.WikiPageUtil;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.xhtml.PrintInlineListener;

public class PrintListener
extends PrintInlineListener {
    public PrintListener(IWikiPrinter printer) {
        super(printer);
    }

    public void beginDefinitionDescription() {
        this.print("  <dd>");
    }

    public void beginDefinitionList(WikiParameters parameters) {
        this.println("<dl>");
    }

    public void beginDefinitionTerm() {
        this.print("  <dt>");
    }

    public void beginDocument() {
        this.println("<div class='doc'>");
    }

    public void beginHeader(int level, WikiParameters params) {
        this.print("<h" + level + params + ">");
    }

    public void beginInfoBlock(char infoType, WikiParameters params) {
        this.print("<table" + params + "><tr><th>" + infoType + "</th><td>");
    }

    public void beginList(WikiParameters parameters, boolean ordered) {
        if (ordered) {
            this.println("<ol" + parameters + ">");
        } else {
            this.println("<ul" + parameters + ">");
        }
    }

    public void beginListItem() {
        this.print("  <li>");
    }

    public void beginParagraph(WikiParameters params) {
        this.print("<p" + params + ">");
    }

    public void beginPropertyBlock(String propertyUri, boolean doc) {
        this.print("<div class='property' url='" + WikiPageUtil.escapeXmlAttribute(propertyUri) + "'>");
        if (doc) {
            this.println("");
        }
    }

    public void beginQuotation(WikiParameters params) {
        this.println("<blockquote" + params + ">");
    }

    public void beginQuotationLine() {
    }

    public void beginTable(WikiParameters params) {
        this.println("<table" + params + "><tbody>");
    }

    public void beginTableCell(boolean tableHead, WikiParameters params) {
        String str = tableHead ? "<th" : "<td";
        this.print(str + params + ">");
    }

    public void beginTableRow(WikiParameters params) {
        this.print("  <tr" + params + ">");
    }

    public void endDefinitionDescription() {
        this.println("</dd>");
    }

    public void endDefinitionList(WikiParameters parameters) {
        this.println("</dl>");
    }

    public void endDefinitionTerm() {
        this.println("</dt>");
    }

    public void endDocument() {
        this.println("</div>");
    }

    public void endHeader(int level, WikiParameters params) {
        this.println("</h" + level + ">");
    }

    public void endInfoBlock(char infoType, WikiParameters params) {
        this.println("</td></tr></table>");
    }

    public void endList(WikiParameters parameters, boolean ordered) {
        if (ordered) {
            this.println("</ol>");
        } else {
            this.println("</ul>");
        }
    }

    public void endListItem() {
        this.println("</li>");
    }

    public void endParagraph(WikiParameters params) {
        this.println("</p>");
    }

    public void endPropertyBlock(String propertyUri, boolean doc) {
        this.println("</div>");
    }

    public void endQuotation(WikiParameters params) {
        this.println("</blockquote>");
    }

    public void endQuotationLine() {
        this.println("");
    }

    public void endTable(WikiParameters params) {
        this.println("</tbody></table>");
    }

    public void endTableCell(boolean tableHead, WikiParameters params) {
        String str = tableHead ? "</th>" : "</td>";
        this.print(str);
    }

    public void endTableRow(WikiParameters params) {
        this.println("</tr>");
    }

    public void onEmptyLines(int count) {
        if (count > 1) {
            this.println("<div style='height:" + count + "em;'></div>");
        }
    }

    public void onExtensionBlock(String extensionName, WikiParameters params) {
        this.println("<div class='extension' extension='" + extensionName + "'" + params + "/>");
    }

    public void onHorizontalLine(WikiParameters params) {
        this.println("<hr" + params + " />");
    }

    public void onMacroBlock(String macroName, WikiParameters params, String content) {
        this.println("<pre class='macro' macroName='" + macroName + "'" + params + "><![CDATA[" + content + "]]></pre>");
    }

    public void onMacroInline(String macroName, WikiParameters params, String content) {
        this.print("<span class='macro' macroName='" + macroName + "'" + params + "><![CDATA[" + content + "]]></span>");
    }

    public void onTableCaption(String str) {
    }

    public void onVerbatimBlock(String str, WikiParameters params) {
        this.println("<pre" + params + ">" + WikiPageUtil.escapeXmlString(str) + "</pre>");
    }
}

