/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.wikimodel.wem.xhtml.filter.DefaultXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XHTMLWhitespaceXMLFilter
extends DefaultXMLFilter {
    private static final Pattern HTML_WHITESPACE_DUPLICATES_PATTERN = Pattern.compile("\\s{2,}|[\\t\\n\\x0B\\f\\r]+");
    private static final Pattern HTML_WHITESPACE_HEAD_PATTERN = Pattern.compile("^\\s+");
    private static final Pattern HTML_WHITESPACE_TAIL_PATTERN = Pattern.compile("\\s+$");
    private static final List<String> NONINLINE_ELEMENTS = Arrays.asList("html", "head", "body", "p", "table", "ul", "ol", "li", "hr", "td", "tr", "th", "div", "tbody", "thead", "pre", "h1", "h2", "h3", "h4", "h5", "h6", "dl", "dt", "dd", "blockquote");
    private static final List<String> INLINECONTAINER_ELEMENTS = Arrays.asList("p", "li", "hr", "td", "th", "div", "thead", "pre", "h1", "h2", "h3", "h4", "h5", "h6", "dl", "dt", "dd", "blockquote");
    private boolean fRemoveWhitespaces = true;
    private int inlineDepth = 0;
    private StringBuffer fContent = new StringBuffer();
    private StringBuffer fPreviousInlineContent = new StringBuffer();
    private String fPreviousContent = null;
    private List<String[]> fEndingInlineElements = new ArrayList<String[]>();

    public XHTMLWhitespaceXMLFilter() {
    }

    public XHTMLWhitespaceXMLFilter(XMLReader reader) {
        super(reader);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        super.ignorableWhitespace(ch, start, length);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.getContent().append(ch, start, length);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.cleanBeforeElement();
        this.cleanExtraWhiteSpaces();
        this.sendContent();
        if (INLINECONTAINER_ELEMENTS.contains(localName)) {
            ++this.inlineDepth;
            this.fPreviousInlineContent.setLength(0);
        }
        super.startElement(uri, localName, qName, atts);
        if ("pre".equalsIgnoreCase(localName)) {
            this.fRemoveWhitespaces = false;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.cleanInlineContentFirstSpaces();
        this.cleanExtraWhiteSpaces();
        if (NONINLINE_ELEMENTS.contains(localName)) {
            this.trimTrailingWhiteSpaces();
            this.sendContent();
            this.fPreviousInlineContent.setLength(0);
            this.fRemoveWhitespaces = true;
            if (INLINECONTAINER_ELEMENTS.contains(localName)) {
                --this.inlineDepth;
            }
            super.endElement(uri, localName, qName);
        } else {
            if (this.getContent().length() > 0) {
                this.sendPreviousContent(false);
                this.fPreviousInlineContent.append(this.getContent());
                this.fPreviousContent = this.getContent().toString();
            }
            this.getContent().setLength(0);
            this.fEndingInlineElements.add(new String[]{uri, localName, qName});
        }
    }

    public void startCDATA() throws SAXException {
        this.cleanInlineContentFirstSpaces();
        this.cleanExtraWhiteSpaces();
        this.sendContent();
        this.fRemoveWhitespaces = false;
        super.startCDATA();
    }

    public void endCDATA() throws SAXException {
        if (this.getContent().length() > 0) {
            this.sendContent();
        }
        super.endCDATA();
        this.fRemoveWhitespaces = true;
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        this.cleanBeforeElement();
        this.cleanExtraWhiteSpaces();
        this.sendContent();
        if (this.isSemanticComment(new String(ch, start, length))) {
            this.fPreviousInlineContent.append("semanticcomment");
        }
        super.comment(ch, start, length);
    }

    protected boolean shouldRemoveWhiteSpaces() {
        return this.fRemoveWhitespaces;
    }

    protected void sendPreviousContent(boolean trimTrailing) throws SAXException {
        if (this.fEndingInlineElements.size() > 0) {
            if (this.fPreviousContent != null && this.fPreviousContent.length() > 0) {
                if (trimTrailing) {
                    this.fPreviousContent = this.trimTrailingWhiteSpaces(this.fPreviousContent);
                }
                this.sendCharacters(this.fPreviousContent);
            }
            for (String[] element : this.fEndingInlineElements) {
                super.endElement(element[0], element[1], element[2]);
            }
            this.fEndingInlineElements.clear();
        }
        this.fPreviousContent = null;
    }

    protected void sendContent() throws SAXException {
        this.sendPreviousContent(this.getContent().length() == 0);
        if (this.getContent().length() > 0) {
            this.fPreviousInlineContent.append(this.getContent());
            this.sendCharacters(this.getContent().toString());
            this.getContent().setLength(0);
        }
    }

    protected void sendCharacters(String content) throws SAXException {
        if (content.length() > 0) {
            super.characters(content.toCharArray(), 0, content.length());
        }
    }

    private void cleanBeforeElement() {
        if (this.inlineDepth == 0) {
            this.trimLeadingWhiteSpaces();
            this.trimTrailingWhiteSpaces();
        } else {
            this.cleanInlineContentFirstSpaces();
        }
    }

    private void cleanInlineContentFirstSpaces() {
        if (this.getContent().length() > 0 && (this.fPreviousInlineContent.length() == 0 || this.fPreviousInlineContent.charAt(this.fPreviousInlineContent.length() - 1) == ' ')) {
            this.trimLeadingWhiteSpaces();
        }
    }

    protected void cleanExtraWhiteSpaces() {
        if (this.getContent().length() > 0 && this.shouldRemoveWhiteSpaces()) {
            Matcher matcher = HTML_WHITESPACE_DUPLICATES_PATTERN.matcher(this.getContent());
            String result = matcher.replaceAll(" ");
            this.getContent().setLength(0);
            this.getContent().append(result);
        }
    }

    protected void trimLeadingWhiteSpaces() {
        if (this.shouldRemoveWhiteSpaces() && this.getContent().length() > 0) {
            String result = this.trimLeadingWhiteSpaces(this.getContent());
            this.getContent().setLength(0);
            this.getContent().append(result);
        }
    }

    protected String trimLeadingWhiteSpaces(CharSequence content) {
        String trimedContent;
        if (this.shouldRemoveWhiteSpaces() && content.length() > 0) {
            Matcher matcher = HTML_WHITESPACE_HEAD_PATTERN.matcher(content);
            trimedContent = matcher.replaceAll("");
        } else {
            trimedContent = ((Object)content).toString();
        }
        return trimedContent;
    }

    protected void trimTrailingWhiteSpaces() {
        if (this.shouldRemoveWhiteSpaces() && this.getContent().length() > 0) {
            String result = this.trimTrailingWhiteSpaces(this.getContent());
            this.getContent().setLength(0);
            this.getContent().append(result);
        }
    }

    protected String trimTrailingWhiteSpaces(CharSequence content) {
        String trimedContent;
        if (this.shouldRemoveWhiteSpaces() && this.getContent().length() > 0) {
            Matcher matcher = HTML_WHITESPACE_TAIL_PATTERN.matcher(content);
            trimedContent = matcher.replaceAll("");
        } else {
            trimedContent = ((Object)content).toString();
        }
        return trimedContent;
    }

    protected StringBuffer getContent() {
        return this.fContent;
    }

    protected boolean isSemanticComment(String comment) {
        return comment.startsWith("startmacro:") || comment.startsWith("stopmacro");
    }
}

