/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xhtml.handler;

import java.util.Stack;
import org.wikimodel.wem.xhtml.impl.XhtmlHandler;

public class TagHandler {
    private boolean fAccumulateContent;
    private final boolean fContentContainer;
    private final boolean fDocumentContainer;
    private final boolean fRequiresDocument;

    private static boolean requiresParentDocument(XhtmlHandler.TagStack.TagContext context) {
        if (context == null) {
            return true;
        }
        if (context.fHandler == null || !context.fHandler.requiresDocument()) {
            return false;
        }
        boolean inContainer = false;
        for (XhtmlHandler.TagStack.TagContext parent = context.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.fHandler == null) continue;
            inContainer = parent.fHandler.isDocumentContainer();
            break;
        }
        return inContainer;
    }

    public TagHandler(boolean documentContainer, boolean requiresDocument, boolean contentContainer) {
        this.fDocumentContainer = documentContainer;
        this.fRequiresDocument = requiresDocument;
        this.fContentContainer = contentContainer;
    }

    protected void begin(XhtmlHandler.TagStack.TagContext context) {
    }

    public void beginElement(XhtmlHandler.TagStack.TagContext context) {
        Stack insideBlockElementsStack = (Stack)context.getTagStack().getStackParameter("insideBlockElement");
        if (this.isBlockHandler(context)) {
            if (!insideBlockElementsStack.isEmpty() && ((Boolean)insideBlockElementsStack.peek()).booleanValue()) {
                context.getScannerContext().beginDocument();
                insideBlockElementsStack.push(false);
                Stack tagNames = (Stack)context.getTagStack().getStackParameter("tagNameBeforeNestedDocument");
                tagNames.push(context.getParent().getName());
            }
            insideBlockElementsStack.push(true);
        }
        this.begin(context);
    }

    protected void end(XhtmlHandler.TagStack.TagContext context) {
    }

    public final void endElement(XhtmlHandler.TagStack.TagContext context) {
        Stack tagNames;
        this.end(context);
        Stack insideBlockElementsStack = (Stack)context.getTagStack().getStackParameter("insideBlockElement");
        if (this.isBlockHandler(context)) {
            insideBlockElementsStack.pop();
        }
        if (!(tagNames = (Stack)context.getTagStack().getStackParameter("tagNameBeforeNestedDocument")).isEmpty() && context.getName().equals(tagNames.peek())) {
            context.getScannerContext().endDocument();
            tagNames.pop();
            insideBlockElementsStack.pop();
        }
    }

    public boolean isContentContainer() {
        return this.fContentContainer;
    }

    public boolean isDocumentContainer() {
        return this.fDocumentContainer;
    }

    public boolean requiresDocument() {
        return this.fRequiresDocument;
    }

    public void setAccumulateContent(boolean accumulateContent) {
        this.fAccumulateContent = accumulateContent;
    }

    public boolean isAccumulateContent() {
        return this.fAccumulateContent;
    }

    public static void sendEmptyLines(XhtmlHandler.TagStack.TagContext context) {
        int lineCount = (Integer)context.getTagStack().getStackParameter("emptyLinesCount");
        if (lineCount > 0) {
            context.getScannerContext().onEmptyLines(lineCount);
            context.getTagStack().setStackParameter("emptyLinesCount", 0);
        }
    }

    public void initialize(XhtmlHandler.TagStack stack) {
    }

    public boolean isBlockHandler(XhtmlHandler.TagStack.TagContext context) {
        return false;
    }
}

