/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.impl;

import java.util.Stack;
import org.wikimodel.wem.IWemListener;
import org.wikimodel.wem.WikiFormat;
import org.wikimodel.wem.WikiParameters;
import org.wikimodel.wem.WikiReference;
import org.wikimodel.wem.WikiStyle;
import org.wikimodel.wem.impl.IWikiScannerContext;
import org.wikimodel.wem.impl.InlineState;
import org.wikimodel.wem.util.IListListener;
import org.wikimodel.wem.util.ListBuilder;

class InternalWikiScannerContext
implements IWikiScannerContext {
    private int fBlockType = 0;
    private WikiParameters fDocumentParams = null;
    private WikiFormat fFormat;
    private int fHeaderLevel;
    private WikiParameters fHeaderParams;
    private WikiParameters fInfoParams;
    private String fInfoType;
    private String fInlineProperty;
    private InlineState fInlineState = new InlineState();
    private ListBuilder fListBuilder;
    private final IWemListener fListener;
    private WikiParameters fListParams;
    private WikiFormat fNewFormat = WikiFormat.EMPTY;
    private WikiParameters fParagraphParams;
    private Stack<Boolean> fPropertyDocStack = new Stack();
    private Stack<String> fPropertyStack = new Stack();
    private ListBuilder fQuotBuilder;
    private int fQuoteDepth = 0;
    private WikiParameters fQuotParams;
    private int fTableCellCounter = -1;
    private WikiParameters fTableCellParams = WikiParameters.EMPTY;
    private boolean fTableHead;
    private WikiParameters fTableParams;
    private int fTableRowCounter = -1;
    private WikiParameters fTableRowParams;
    private String fVerbatimContent = null;
    private WikiParameters fVerbatimParameters = WikiParameters.EMPTY;
    private String fMacroName = null;
    private WikiParameters fMacroParameters = WikiParameters.EMPTY;
    private String fMacroContent = null;

    public InternalWikiScannerContext(IWemListener listener) {
        this.fListener = listener;
    }

    public void beginDocument() {
        this.fInlineState.set(InlineState.BEGIN_FORMAT);
        this.fListener.beginDocument();
    }

    public void beginDocument(WikiParameters params) {
        this.fDocumentParams = params;
        this.fInlineState.set(InlineState.BEGIN_FORMAT);
        this.fListener.beginDocument(this.fDocumentParams);
    }

    public void beginHeader(int level) {
        this.beginHeader(level, WikiParameters.EMPTY);
    }

    public void beginHeader(int level, WikiParameters params) {
        if (level < 1) {
            level = 1;
        } else if (level > 6) {
            level = 6;
        }
        if (this.fBlockType != 2) {
            this.closeBlock();
            this.fBlockType = 2;
            this.fHeaderLevel = level;
            this.fHeaderParams = params;
            this.fListener.beginHeader(level, this.fHeaderParams);
        }
        this.beginStyleContainer();
    }

    public void beginInfo(String type, WikiParameters params) {
        if ((this.fBlockType & 4) != 4) {
            this.closeBlock();
            this.fInfoType = type;
            this.fInfoParams = params != null ? params : WikiParameters.EMPTY;
            this.fListener.beginInfoBlock(this.fInfoType, this.fInfoParams);
            this.fBlockType = 4;
        }
        this.beginStyleContainer();
    }

    public void beginList() {
        if ((this.fBlockType & 8) != 8) {
            this.closeBlock();
            if (this.fListParams == null) {
                this.fListParams = WikiParameters.EMPTY;
            }
            IListListener listener = new IListListener(){
                private Stack<WikiParameters> fListParamsStack = new Stack();

                public void beginRow(char treeType, char rowType) {
                    if (rowType == ':') {
                        InternalWikiScannerContext.this.fBlockType = 56;
                        InternalWikiScannerContext.this.fListener.beginDefinitionDescription();
                    } else if (rowType == ';') {
                        InternalWikiScannerContext.this.fBlockType = 88;
                        InternalWikiScannerContext.this.fListener.beginDefinitionTerm();
                    } else {
                        InternalWikiScannerContext.this.fBlockType = 136;
                        InternalWikiScannerContext.this.fListener.beginListItem();
                    }
                    InternalWikiScannerContext.this.beginStyleContainer();
                }

                public void beginTree(char type) {
                    this.fListParamsStack.push(InternalWikiScannerContext.this.fListParams);
                    InternalWikiScannerContext.this.closeFormat();
                    switch (type) {
                        case '#': {
                            InternalWikiScannerContext.this.fListener.beginList(InternalWikiScannerContext.this.fListParams, true);
                            InternalWikiScannerContext.this.fBlockType = 8;
                            break;
                        }
                        case 'd': {
                            InternalWikiScannerContext.this.fListener.beginDefinitionList(InternalWikiScannerContext.this.fListParams);
                            InternalWikiScannerContext.this.fBlockType = 24;
                            break;
                        }
                        default: {
                            InternalWikiScannerContext.this.fListener.beginList(InternalWikiScannerContext.this.fListParams, false);
                            InternalWikiScannerContext.this.fBlockType = 8;
                        }
                    }
                    InternalWikiScannerContext.this.fListParams = WikiParameters.EMPTY;
                }

                public void endRow(char treeType, char rowType) {
                    InternalWikiScannerContext.this.closeFormat();
                    InternalWikiScannerContext.this.endStyleContainer();
                    if (rowType == ':') {
                        InternalWikiScannerContext.this.fListener.endDefinitionDescription();
                        InternalWikiScannerContext.this.fBlockType = 24;
                    } else if (rowType == ';') {
                        if ((InternalWikiScannerContext.this.fBlockType & 0x58) == 88) {
                            InternalWikiScannerContext.this.fListener.endDefinitionTerm();
                        } else {
                            InternalWikiScannerContext.this.fListener.endDefinitionDescription();
                        }
                        InternalWikiScannerContext.this.fBlockType = 24;
                    } else {
                        InternalWikiScannerContext.this.fListener.endListItem();
                        InternalWikiScannerContext.this.fBlockType = 8;
                    }
                }

                public void endTree(char type) {
                    switch (type) {
                        case '#': {
                            InternalWikiScannerContext.this.fListener.endList(this.fListParamsStack.peek(), true);
                            InternalWikiScannerContext.this.fBlockType = 8;
                            break;
                        }
                        case 'd': {
                            InternalWikiScannerContext.this.fListener.endDefinitionList(this.fListParamsStack.peek());
                            InternalWikiScannerContext.this.fBlockType = 8;
                            break;
                        }
                        default: {
                            InternalWikiScannerContext.this.fListener.endList(this.fListParamsStack.peek(), false);
                            InternalWikiScannerContext.this.fBlockType = 8;
                        }
                    }
                    this.fListParamsStack.pop();
                }
            };
            this.fListBuilder = new ListBuilder(listener){

                protected char getTreeType(char rowType) {
                    if (rowType == ';' || rowType == ':') {
                        return 'd';
                    }
                    return rowType;
                }
            };
            this.fBlockType = 8;
        }
    }

    public void beginList(WikiParameters params) {
        this.fListParams = params;
        this.beginList();
    }

    public void beginListItem(String item) {
        this.beginListItem(item, WikiParameters.EMPTY);
    }

    public void beginListItem(String item, WikiParameters params) {
        this.beginList();
        if (this.fListParams == WikiParameters.EMPTY) {
            this.fListParams = params;
        }
        item = this.trimLineBreaks(item);
        int idx = (item = this.replace(item, ";:", ":")).indexOf(59);
        if (idx >= 0) {
            item = item.substring(0, idx + 1);
        }
        this.fListBuilder.alignContext(item);
    }

    public void beginParagraph() {
        if (this.fBlockType != 256) {
            this.closeBlock();
            if (this.fParagraphParams == null) {
                this.fParagraphParams = WikiParameters.EMPTY;
            }
            this.fListener.beginParagraph(this.fParagraphParams);
            this.fBlockType = 256;
            this.beginStyleContainer();
        }
    }

    public void beginParagraph(WikiParameters params) {
        this.fParagraphParams = params;
        this.beginParagraph();
    }

    public void beginPropertyBlock(String property, boolean doc) {
        this.closeBlock();
        this.fPropertyStack.push(property);
        this.fPropertyDocStack.push(doc);
        this.fListener.beginPropertyBlock(property, doc);
    }

    public void beginPropertyInline(String str) {
        this.closeFormat();
        this.beginStyleContainer();
        this.fInlineProperty = str;
        this.fListener.beginPropertyInline(this.fInlineProperty);
    }

    public void beginQuot() {
        if ((this.fBlockType & 0x200) != 512) {
            this.closeBlock();
            if (this.fQuotParams == null) {
                this.fQuotParams = WikiParameters.EMPTY;
            }
            IListListener listener = new IListListener(){

                public void beginRow(char treeType, char rowType) {
                    InternalWikiScannerContext.this.fBlockType = 1536;
                    InternalWikiScannerContext.this.fListener.beginQuotationLine();
                    InternalWikiScannerContext.this.beginStyleContainer();
                }

                public void beginTree(char type) {
                    InternalWikiScannerContext.this.closeFormat();
                    InternalWikiScannerContext.this.fListener.beginQuotation(InternalWikiScannerContext.this.fQuotParams);
                    InternalWikiScannerContext.this.fBlockType = 512;
                }

                public void endRow(char treeType, char rowType) {
                    InternalWikiScannerContext.this.closeFormat();
                    InternalWikiScannerContext.this.endStyleContainer();
                    InternalWikiScannerContext.this.fListener.endQuotationLine();
                    InternalWikiScannerContext.this.fBlockType = 512;
                }

                public void endTree(char type) {
                    InternalWikiScannerContext.this.closeFormat();
                    InternalWikiScannerContext.this.fListener.endQuotation(InternalWikiScannerContext.this.fQuotParams);
                    InternalWikiScannerContext.this.fBlockType = 512;
                }
            };
            this.fQuotBuilder = new ListBuilder(listener);
            this.fBlockType = 512;
        }
    }

    public void beginQuot(WikiParameters params) {
        this.fQuotParams = params;
        this.beginQuot();
    }

    public void beginQuotLine(int depth) {
        this.beginQuot();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < depth; ++i) {
            buf.append(" ");
        }
        buf.append("*");
        this.fQuoteDepth = depth;
        this.fQuotBuilder.alignContext(buf.toString());
    }

    private void beginStyleContainer() {
        this.fInlineState.set(InlineState.BEGIN);
    }

    public void beginTable() {
        if ((this.fBlockType & 0x800) != 2048) {
            this.closeBlock();
            if (this.fTableParams == null) {
                this.fTableParams = WikiParameters.EMPTY;
            }
            this.fTableRowCounter = 0;
            this.fListener.beginTable(this.fTableParams);
            this.fBlockType = 2048;
        }
    }

    public void beginTable(WikiParameters params) {
        this.fTableParams = params;
        this.beginTable();
    }

    public void beginTableCell(boolean headCell) {
        this.beginTableCell(headCell, this.fTableCellParams);
    }

    public void beginTableCell(boolean headCell, WikiParameters params) {
        if ((this.fBlockType & 0x3800) != 14336) {
            this.beginTableRow(null);
            this.fTableHead = headCell;
            this.fTableCellParams = params != null ? params : WikiParameters.EMPTY;
            this.fListener.beginTableCell(this.fTableHead, this.fTableCellParams);
            this.fBlockType = 14336;
            this.beginStyleContainer();
        }
    }

    public void beginTableRow(boolean headCell) {
        if (this.beginTableRowInternal(null)) {
            this.beginTableCell(headCell, null);
        }
    }

    public void beginTableRow(boolean head, WikiParameters rowParams, WikiParameters cellParams) {
        if (this.beginTableRowInternal(rowParams)) {
            this.beginTableCell(head, cellParams);
        }
    }

    public void beginTableRow(WikiParameters rowParams) {
        this.beginTableRowInternal(rowParams);
    }

    private boolean beginTableRowInternal(WikiParameters rowParams) {
        boolean result = false;
        if ((this.fBlockType & 0x1800) != 6144) {
            this.beginTable();
            this.fBlockType = 6144;
            this.fTableCellCounter = 0;
            this.fTableRowParams = rowParams != null ? rowParams : WikiParameters.EMPTY;
            this.fListener.beginTableRow(this.fTableRowParams);
            result = true;
        }
        return result;
    }

    public boolean canApplyDefintionSplitter() {
        return this.fBlockType == 88;
    }

    void checkBlockContainer() {
        if (this.isInTable()) {
            this.checkTableCell();
        } else if (this.isInList()) {
            this.checkListItem();
        } else if (!this.isInTableCell() && !this.isInListItem()) {
            this.closeBlock();
        } else if (this.isInQuotation()) {
            this.checkQuotationLine();
        }
    }

    public boolean checkFormatStyle(WikiStyle style) {
        return style != null && this.fFormat != null && this.fFormat.hasStyle(style);
    }

    private void checkListItem() {
        if (!this.isInListItem()) {
            this.beginListItem("*");
        }
    }

    private void checkParagraph() {
        if (!this.isInParagraph()) {
            this.beginParagraph();
        }
    }

    private void checkVerbatim(boolean inline) {
        if (this.fVerbatimContent != null) {
            if (!inline) {
                this.fListener.onVerbatimBlock(this.fVerbatimContent, this.fVerbatimParameters);
            } else {
                this.fListener.onVerbatimInline(this.fVerbatimContent, this.fVerbatimParameters);
            }
            this.fVerbatimContent = null;
            this.fVerbatimParameters = WikiParameters.EMPTY;
        }
    }

    private void checkMacro(boolean inline) {
        if (this.fMacroName != null) {
            if (!inline) {
                this.fListener.onMacroBlock(this.fMacroName, this.fMacroParameters, this.fMacroContent);
            } else {
                this.fListener.onMacroInline(this.fMacroName, this.fMacroParameters, this.fMacroContent);
            }
            this.fMacroName = null;
            this.fMacroParameters = WikiParameters.EMPTY;
            this.fMacroContent = null;
        }
    }

    private void checkQuotationLine() {
        if (!this.isInQuotationLine()) {
            this.beginQuotLine(this.fQuoteDepth);
        }
    }

    private void checkStyleOpened() {
        if (this.isInTable()) {
            this.checkTableCell();
        } else if (this.isInList()) {
            this.checkListItem();
        } else if (this.isInQuotation()) {
            this.checkQuotationLine();
        } else if (this.isNoBlockElements()) {
            String verbatimContent = this.fVerbatimContent;
            String macroName = this.fMacroName;
            this.fVerbatimContent = null;
            this.fMacroName = null;
            this.checkParagraph();
            this.fMacroName = macroName;
            this.fVerbatimContent = verbatimContent;
        }
        this.openFormat();
        this.checkVerbatim(true);
        this.checkMacro(true);
    }

    private void checkTableCell() {
        if (!this.isInTableCell()) {
            this.beginTableCell(this.fTableHead);
        }
    }

    public void closeBlock() {
        this.checkVerbatim(false);
        this.checkMacro(false);
        switch (this.fBlockType) {
            case 0: {
                break;
            }
            case 2: {
                this.endHeader();
                break;
            }
            case 256: {
                this.endParagraph();
                break;
            }
            case 4: {
                this.endInfo();
                break;
            }
            default: {
                if ((this.fBlockType & 0x800) != 0) {
                    this.endTable();
                    break;
                }
                if ((this.fBlockType & 8) != 0) {
                    this.endList();
                    break;
                }
                if ((this.fBlockType & 0x200) == 0) break;
                this.endQuot();
            }
        }
    }

    public void closeFormat() {
        this.closeFormat(true);
    }

    private void closeFormat(boolean resetNewStyle) {
        if (this.fFormat != null) {
            this.fListener.endFormat(this.fFormat);
            this.fFormat = null;
        }
        if (resetNewStyle) {
            this.fNewFormat = WikiFormat.EMPTY;
        }
    }

    public void endDocument() {
        this.closeBlock();
        if (this.fDocumentParams == null) {
            this.fListener.endDocument();
        } else {
            this.fListener.endDocument(this.fDocumentParams);
        }
    }

    public void endHeader() {
        if ((this.fBlockType & 2) != 0) {
            this.closeFormat();
            this.endStyleContainer();
            this.fListener.endHeader(this.fHeaderLevel, this.fHeaderParams);
            this.fHeaderLevel = -1;
            this.fBlockType = 0;
        }
    }

    public void endInfo() {
        if ((this.fBlockType & 4) != 0) {
            this.closeFormat();
            this.endStyleContainer();
            this.fListener.endInfoBlock(this.fInfoType, this.fInfoParams);
            this.fInfoType = "";
            this.fInfoParams = null;
            this.fBlockType = 0;
        }
    }

    public void endList() {
        if ((this.fBlockType & 8) != 0) {
            this.fListBuilder.alignContext("");
            this.fListBuilder = null;
            this.fBlockType = 0;
        }
    }

    public void endListItem() {
    }

    public void endParagraph() {
        if ((this.fBlockType & 0x100) != 0) {
            this.closeFormat();
            this.endStyleContainer();
            this.fListener.endParagraph(this.fParagraphParams);
            this.fBlockType = 0;
            this.fParagraphParams = WikiParameters.EMPTY;
        }
    }

    public void endPropertyBlock() {
        this.closeBlock();
        String property = this.fPropertyStack.pop();
        boolean doc = this.fPropertyDocStack.pop();
        this.fListener.endPropertyBlock(property, doc);
    }

    public void endPropertyInline() {
        this.closeFormat();
        this.endStyleContainer();
        this.fListener.endPropertyInline(this.fInlineProperty);
        this.fInlineProperty = null;
    }

    public void endQuot() {
        if ((this.fBlockType & 0x200) != 0) {
            this.closeFormat();
            this.fQuotBuilder.alignContext("");
            this.fQuotBuilder = null;
            this.fBlockType = 0;
        }
    }

    public void endQuotLine() {
        --this.fQuoteDepth;
        if (this.fQuoteDepth < 0) {
            this.fQuoteDepth = 0;
        }
        this.fBlockType = 512;
    }

    private void endStyleContainer() {
        this.fInlineState.set(InlineState.BEGIN);
    }

    public void endTable() {
        if ((this.fBlockType & 0x800) == 2048) {
            this.endTableRow();
            this.fListener.endTable(this.fTableParams);
            this.fTableRowCounter = -1;
            this.fBlockType = 0;
        }
    }

    public void endTableCell() {
        if ((this.fBlockType & 0x3800) == 14336) {
            this.closeFormat();
            this.endStyleContainer();
            this.fListener.endTableCell(this.fTableHead, this.fTableCellParams);
            ++this.fTableCellCounter;
            this.fBlockType = 6144;
            this.fTableCellParams = WikiParameters.EMPTY;
        }
    }

    public void endTableExplicit() {
        this.endTable();
    }

    public void endTableRow() {
        if ((this.fBlockType & 0x1800) == 6144) {
            if (this.fTableCellCounter <= 0) {
                this.checkTableCell();
            }
            this.endTableCell();
            this.fListener.endTableRow(this.fTableRowParams);
            this.fBlockType = 2048;
            this.fTableHead = false;
            this.fTableCellCounter = -1;
            ++this.fTableRowCounter;
        }
    }

    public InlineState getInlineState() {
        return this.fInlineState;
    }

    public int getTableCellCounter() {
        return this.fTableCellCounter;
    }

    public int getTableRowCounter() {
        return this.fTableRowCounter;
    }

    public boolean isInDefinitionList() {
        return (this.fBlockType & 0x18) == 24;
    }

    public boolean isInDefinitionTerm() {
        return this.fBlockType == 88;
    }

    public boolean isInHeader() {
        return this.fHeaderLevel > 0;
    }

    public boolean isInInlineProperty() {
        return this.fInlineProperty != null;
    }

    public boolean isInList() {
        return this.fBlockType == 8;
    }

    private boolean isInListItem() {
        return (this.fBlockType & 0x88) == 136;
    }

    private boolean isInParagraph() {
        return this.fBlockType == 256;
    }

    public boolean isInQuotation() {
        return this.fBlockType == 512;
    }

    private boolean isInQuotationLine() {
        return (this.fBlockType & 0x600) == 1536;
    }

    public boolean isInTable() {
        return (this.fBlockType & 0x800) == 2048;
    }

    public boolean isInTableCell() {
        return (this.fBlockType & 0x3800) == 14336;
    }

    public boolean isInTableRow() {
        return (this.fBlockType & 0x1800) == 6144;
    }

    private boolean isNoBlockElements() {
        return this.fBlockType == 0;
    }

    public void onDefinitionListItemSplit() {
        this.closeFormat();
        if ((this.fBlockType & 0x58) == 88) {
            this.closeFormat();
            this.endStyleContainer();
            this.fListener.endDefinitionTerm();
        } else if ((this.fBlockType & 0x38) == 56) {
            this.closeFormat();
            this.endStyleContainer();
            this.fListener.endDefinitionDescription();
        }
        this.fBlockType = 56;
        this.fListener.beginDefinitionDescription();
        this.beginStyleContainer();
    }

    public void onEmptyLines(int count) {
        this.closeBlock();
        this.fListener.onEmptyLines(count);
    }

    public void onEscape(String str) {
        this.checkStyleOpened();
        this.fListener.onEscape(str);
        this.fInlineState.set(InlineState.ESCAPE);
    }

    public void onExtensionBlock(String extensionName, WikiParameters params) {
        this.fListener.onExtensionBlock(extensionName, params);
    }

    public void onExtensionInline(String extensionName, WikiParameters params) {
        this.fListener.onExtensionInline(extensionName, params);
        this.fInlineState.set(InlineState.EXTENSION);
    }

    public void onFormat(WikiParameters params) {
        this.closeFormat(false);
        this.fNewFormat = this.fNewFormat.setParameters(params.toList());
        this.fInlineState.set(InlineState.BEGIN_FORMAT);
    }

    public void onFormat(WikiStyle wikiStyle) {
        this.onFormat(wikiStyle, false);
    }

    public void onFormat(WikiStyle wikiStyle, boolean forceClose) {
        this.closeFormat(false);
        this.fNewFormat = forceClose ? this.fNewFormat.removeStyle(wikiStyle) : this.fNewFormat.switchStyle(wikiStyle);
        this.fInlineState.set(InlineState.BEGIN_FORMAT);
    }

    public void beginFormat(WikiParameters params) {
        this.closeFormat(false);
        this.fNewFormat = this.fNewFormat.setParameters(params.toList());
        this.fInlineState.set(InlineState.BEGIN_FORMAT);
    }

    public void beginFormat(WikiStyle wikiStyle) {
        this.closeFormat(false);
        this.fNewFormat = this.fNewFormat.addStyle(wikiStyle);
        this.fInlineState.set(InlineState.BEGIN_FORMAT);
    }

    public void endFormat(WikiParameters params) {
        this.closeFormat(false);
        this.fNewFormat = this.fNewFormat.setParameters(params.toList());
        this.fInlineState.set(InlineState.BEGIN_FORMAT);
    }

    public void endFormat(WikiStyle wikiStyle) {
        this.closeFormat(false);
        this.fNewFormat = this.fNewFormat.removeStyle(wikiStyle);
        this.fInlineState.set(InlineState.BEGIN_FORMAT);
    }

    public void onHorizontalLine() {
        this.onHorizontalLine(WikiParameters.EMPTY);
    }

    public void onHorizontalLine(WikiParameters params) {
        this.closeBlock();
        this.fListener.onHorizontalLine(params);
    }

    public void onImage(String ref) {
        this.checkStyleOpened();
        this.fListener.onImage(ref);
        this.fInlineState.set(InlineState.IMAGE);
    }

    public void onImage(WikiReference ref) {
        this.checkStyleOpened();
        this.fListener.onImage(ref);
        this.fInlineState.set(InlineState.IMAGE);
    }

    public void onLineBreak() {
        this.checkStyleOpened();
        this.fListener.onLineBreak();
        this.fInlineState.set(InlineState.LINE_BREAK);
    }

    public void onMacro(String name, WikiParameters params, String content) {
        this.checkBlockContainer();
        this.fMacroName = name;
        this.fMacroParameters = params;
        this.fMacroContent = content;
    }

    public void onMacro(String macroName, WikiParameters params, String content, boolean inline) {
        if (inline) {
            this.onMacroInline(macroName, params, content);
        } else {
            this.onMacroBlock(macroName, params, content);
        }
    }

    public void onMacroBlock(String macroName, WikiParameters params, String content) {
        this.checkBlockContainer();
        this.fListener.onMacroBlock(macroName, params, content);
    }

    public void onMacroInline(String macroName, WikiParameters params, String content) {
        this.checkStyleOpened();
        this.fListener.onMacroInline(macroName, params, content);
        this.fInlineState.set(InlineState.MACRO);
    }

    public void onNewLine() {
        this.checkStyleOpened();
        this.fListener.onNewLine();
        this.fInlineState.set(InlineState.NEW_LINE);
    }

    public void onQuotLine(int depth) {
        this.endQuotLine();
        this.beginQuotLine(depth);
    }

    public void onReference(String ref) {
        this.checkStyleOpened();
        this.fListener.onReference(ref);
        this.fInlineState.set(InlineState.REFERENCE);
    }

    public void onReference(WikiReference ref) {
        this.checkStyleOpened();
        this.fListener.onReference(ref);
        this.fInlineState.set(InlineState.REFERENCE);
    }

    public void onSpace(String str) {
        this.checkStyleOpened();
        this.fListener.onSpace(str);
        this.fInlineState.set(InlineState.SPACE);
    }

    public void onSpecialSymbol(String str) {
        this.checkStyleOpened();
        this.fListener.onSpecialSymbol(str);
        this.fInlineState.set(InlineState.SPECIAL_SYMBOL);
    }

    public void onTableCaption(String str) {
        this.beginTable();
        this.fListener.onTableCaption(str);
    }

    public void onTableCell(boolean headCell) {
        this.onTableCell(headCell, null);
    }

    public void onTableCell(boolean head, WikiParameters params) {
        this.endTableCell();
        this.fTableHead = head;
        this.fTableCellParams = params != null ? params : WikiParameters.EMPTY;
    }

    public void onTableRow(WikiParameters params) {
        this.endTableRow();
        this.beginTableRow(params);
    }

    public void onVerbatim(String str, WikiParameters params) {
        this.checkBlockContainer();
        this.fVerbatimContent = str;
        this.fVerbatimParameters = params;
    }

    public void onVerbatim(String str, boolean inline) {
        this.onVerbatim(str, inline, WikiParameters.EMPTY);
    }

    public void onVerbatim(String str, boolean inline, WikiParameters params) {
        if (!inline) {
            this.checkBlockContainer();
            this.fListener.onVerbatimBlock(str, params);
        } else {
            this.checkStyleOpened();
            this.fListener.onVerbatimInline(str, params);
            this.fInlineState.set(InlineState.VERBATIM);
        }
    }

    public void onWord(String str) {
        this.checkStyleOpened();
        this.fListener.onWord(str);
        this.fInlineState.set(InlineState.WORD);
    }

    private void openFormat() {
        if (!this.fNewFormat.equals(this.fFormat)) {
            WikiFormat newFormat = this.fNewFormat;
            this.closeFormat();
            this.fFormat = newFormat;
            this.fNewFormat = newFormat;
            this.fListener.beginFormat(this.fFormat);
        }
        this.fInlineState.set(InlineState.BEGIN_FORMAT);
    }

    private String replace(String item, String from, String to) {
        int pos;
        int prevPos = pos = 0;
        StringBuffer buf = new StringBuffer();
        while (true) {
            if ((pos = item.indexOf(from, pos)) < 0) break;
            buf.append(item.substring(prevPos, pos));
            buf.append(to);
            prevPos = pos += from.length();
        }
        pos = item.length();
        buf.append(item.substring(prevPos, pos));
        return buf.toString();
    }

    private String trimLineBreaks(String item) {
        char[] array;
        StringBuffer buf = new StringBuffer();
        for (char ch : array = item.toCharArray()) {
            if (ch == '\n' || ch == '\r') continue;
            buf.append(ch);
        }
        return buf.toString();
    }

    private static interface IBlockTypes {
        public static final int HEADER = 2;
        public static final int INFO = 4;
        public static final int LIST = 8;
        public static final int LIST_DL = 24;
        public static final int LIST_DL_DD = 56;
        public static final int LIST_DL_DT = 88;
        public static final int LIST_LI = 136;
        public static final int NONE = 0;
        public static final int PARAGRAPH = 256;
        public static final int QUOT = 512;
        public static final int QUOT_LI = 1536;
        public static final int TABLE = 2048;
        public static final int TABLE_ROW = 6144;
        public static final int TABLE_ROW_CELL = 14336;
    }
}

