/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.util;

import java.util.ArrayList;
import java.util.List;
import org.wikimodel.wem.util.IListListener;
import org.wikimodel.wem.util.TreeBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBuilder {
    TreeBuilder<CharPos> fBuilder = new TreeBuilder<CharPos>(new TreeBuilder.ITreeListener<CharPos>(){

        @Override
        public void onBeginRow(CharPos pos) {
            ListBuilder.this.fListener.beginRow(pos.fTreeChar, pos.fRowChar);
        }

        @Override
        public void onBeginTree(CharPos pos) {
            ListBuilder.this.fListener.beginTree(pos.fTreeChar);
        }

        @Override
        public void onEndRow(CharPos pos) {
            ListBuilder.this.fListener.endRow(pos.fTreeChar, pos.fRowChar);
        }

        @Override
        public void onEndTree(CharPos pos) {
            ListBuilder.this.fListener.endTree(pos.fTreeChar);
        }
    });
    private IListListener fListener;

    public ListBuilder(IListListener listener) {
        this.fListener = listener;
    }

    public void alignContext(String row) {
        List<CharPos> list = this.getCharPositions(row);
        this.fBuilder.align((CharPos)((Object)list));
    }

    private List<CharPos> getCharPositions(String s) {
        ArrayList<CharPos> list = new ArrayList<CharPos>();
        char[] array = s.toCharArray();
        int pos = 0;
        for (int i = 0; i < array.length; ++i) {
            char ch = array[i];
            if (ch == '\r' || ch == '\n') continue;
            if (!Character.isSpaceChar(ch)) {
                char treeChar = this.getTreeType(ch);
                list.add(new CharPos(treeChar, ch, pos));
            }
            ++pos;
        }
        return list;
    }

    protected char getTreeType(char rowType) {
        return rowType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class CharPos
    implements TreeBuilder.IPos<CharPos> {
        private int fPos;
        private char fRowChar;
        private char fTreeChar;

        public CharPos(char treeChar, char rowChar, int pos) {
            this.fPos = pos;
            this.fTreeChar = treeChar;
            this.fRowChar = rowChar;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CharPos)) {
                return false;
            }
            CharPos pos = (CharPos)obj;
            return this.equalsData(pos) && pos.fPos == this.fPos;
        }

        @Override
        public boolean equalsData(CharPos pos) {
            return pos.fTreeChar == this.fTreeChar;
        }

        @Override
        public int getPos() {
            return this.fPos;
        }
    }
}

