/*
 * Decompiled with CFR 0.152.
 */
package org.wikimodel.wem.xml.sax;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.wikimodel.wem.WikiPageUtil;
import org.wikimodel.wem.xml.ITagListener;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WemToSax
implements ITagListener {
    private static Logger log = Logger.getLogger(WemToSax.class.getName());
    public static final String USER_NS = "http://www.wikimodel.org/ns/user-defined-params#";
    public static final String USER_PREFIX = "u";
    public static final String WEM_NS = "http://www.wikimodel.org/ns/wem#";
    public static final String WEM_PREFIX = "w";
    private int fDepth;
    private ContentHandler fHandler;

    public WemToSax(ContentHandler handler) {
        this.fHandler = handler;
    }

    @Override
    public void beginTag(String tagName, Map<String, String> tagParams, Map<String, String> userParams) {
        String qualifiedTagName = null;
        try {
            qualifiedTagName = this.getQualifiedName(WEM_PREFIX, tagName);
            if (this.fDepth == 0) {
                this.fHandler.startDocument();
                this.fHandler.startPrefixMapping(WEM_PREFIX, WEM_NS);
                this.fHandler.startPrefixMapping(USER_PREFIX, USER_NS);
            }
            Attributes atts = this.getAttributes(tagParams, userParams);
            this.fHandler.startElement(WEM_NS, tagName, qualifiedTagName, atts);
            ++this.fDepth;
        }
        catch (Throwable t) {
            this.handleError("[BEGIN_TAG] Tag: '" + tagName + "'. QualifiedTagName: '" + qualifiedTagName + "'. " + "TagParams: [" + tagParams + "]. UserParams: [" + userParams + "]", t);
        }
    }

    @Override
    public void endTag(String tagName, Map<String, String> tagParams, Map<String, String> userParams) {
        String qualifiedTagName = null;
        try {
            qualifiedTagName = this.getQualifiedName(WEM_PREFIX, tagName);
            this.fHandler.endElement(WEM_NS, tagName, qualifiedTagName);
            --this.fDepth;
            if (this.fDepth == 0) {
                this.fHandler.endDocument();
            }
        }
        catch (Throwable t) {
            this.handleError("[END_TAG] Tag: '" + tagName + "'. QualifiedTagName: '" + qualifiedTagName + "'. " + "TagParams: [" + tagParams + "]. UserParams: [" + userParams + "]", t);
        }
    }

    private Attributes getAttributes(Map<String, String> tagParams, Map<String, String> userParams) {
        String value;
        String qName;
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : tagParams.entrySet()) {
            qName = this.getQualifiedName(WEM_PREFIX, entry.getKey());
            if (qName == null) continue;
            value = entry.getValue();
            attrs.put(qName, value);
        }
        for (Map.Entry<String, String> entry : userParams.entrySet()) {
            qName = this.getQualifiedName(USER_PREFIX, entry.getKey());
            if (qName == null) continue;
            value = entry.getValue();
            attrs.put(qName, value);
        }
        final Map.Entry[] array = attrs.entrySet().toArray(new Map.Entry[attrs.size()]);
        return new Attributes(){

            private Map.Entry<String, String> getEntry(int index) {
                return array[index];
            }

            @Override
            public int getIndex(String qName) {
                int result = -1;
                for (int i = 0; i < array.length; ++i) {
                    if (!qName.equals(array[i].getKey())) continue;
                    result = i;
                    break;
                }
                return result;
            }

            @Override
            public int getIndex(String uri, String localName) {
                String prefix = null;
                if (WemToSax.WEM_NS.equals(uri)) {
                    prefix = WemToSax.WEM_PREFIX;
                } else if (WemToSax.USER_NS.equals(uri)) {
                    prefix = WemToSax.USER_PREFIX;
                }
                if (prefix == null) {
                    return -1;
                }
                return this.getIndex(prefix + ":" + localName);
            }

            @Override
            public int getLength() {
                return array.length;
            }

            @Override
            public String getLocalName(int index) {
                Map.Entry<String, String> entry = this.getEntry(index);
                if (entry == null) {
                    return null;
                }
                return entry.getKey();
            }

            @Override
            public String getQName(int index) {
                if (index < 0 || index >= array.length) {
                    return null;
                }
                Map.Entry entry = array[index];
                return (String)entry.getKey();
            }

            @Override
            public String getType(int index) {
                return "CDATA";
            }

            @Override
            public String getType(String qName) {
                return "CDATA";
            }

            @Override
            public String getType(String uri, String localName) {
                return "CDATA";
            }

            @Override
            public String getURI(int index) {
                String qName = this.getQName(index);
                if (qName == null) {
                    return null;
                }
                return qName.startsWith(WemToSax.WEM_PREFIX) ? WemToSax.WEM_NS : (qName.startsWith(WemToSax.USER_PREFIX) ? WemToSax.USER_NS : null);
            }

            private String getValue(Map.Entry<String, String> entry) {
                String value = entry != null ? entry.getValue() : null;
                return value != null ? value : "";
            }

            @Override
            public String getValue(int index) {
                Map.Entry<String, String> entry = this.getEntry(index);
                return this.getValue(entry);
            }

            @Override
            public String getValue(String qName) {
                int idx = this.getIndex(qName);
                Map.Entry entry = idx >= 0 ? array[idx] : null;
                return this.getValue(entry);
            }

            @Override
            public String getValue(String uri, String localName) {
                int idx = this.getIndex(uri, localName);
                Map.Entry entry = idx >= 0 ? array[idx] : null;
                return entry != null ? (String)entry.getValue() : null;
            }
        };
    }

    private String getQualifiedName(String prefix, String tagName) {
        if (tagName == null || tagName.length() == 0) {
            return null;
        }
        tagName = WikiPageUtil.escapeXmlAttribute(tagName);
        boolean valid = WikiPageUtil.isValidXmlName(tagName = tagName.replaceAll(" ", "-"), false);
        if (!valid) {
            return null;
        }
        return prefix != null && !"".equals(prefix) ? prefix + ":" + tagName : tagName;
    }

    private void handleError(String s, Throwable e) {
        log.log(Level.SEVERE, s, e);
        if (e instanceof Error) {
            throw (Error)e;
        }
        throw new RuntimeException(e);
    }

    @Override
    public void onCDATA(String content) {
    }

    @Override
    public void onTag(String tagName, Map<String, String> tagParams, Map<String, String> userParams) {
        this.beginTag(tagName, tagParams, userParams);
        this.endTag(tagName, tagParams, userParams);
    }

    @Override
    public void onText(String content) {
        try {
            if (content != null) {
                int i;
                char[] array = content.toCharArray();
                int start = 0;
                for (i = 0; i < array.length; ++i) {
                    char c = array[i];
                    char ch = c;
                    if (WikiPageUtil.isValidXmlChar(ch)) {
                        boolean toEscape;
                        boolean bl = toEscape = ch == '\'' || ch == '\"' || ch == '[' || ch == ']' || ch == '&' || ch == '|';
                        if (!toEscape) continue;
                    }
                    if (i == start) continue;
                    this.fHandler.characters(array, start, i - start);
                    start = i;
                }
                if (i != start) {
                    this.fHandler.characters(array, start, i - start);
                }
            }
        }
        catch (Throwable e) {
            this.handleError("onText error " + content, e);
        }
    }
}

