/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.jboss.as.arquillian.container.NetworkUtils;
import org.jboss.logging.Logger;
import org.xnio.IoUtils;

public final class MBeanServerConnectionProvider
implements Closeable {
    private static final Logger log = Logger.getLogger(MBeanServerConnectionProvider.class);
    private final InetAddress hostAddr;
    private final int port;
    private JMXConnector jmxConnector;

    public static MBeanServerConnectionProvider defaultProvider() throws UnknownHostException {
        return new MBeanServerConnectionProvider(InetAddress.getByName("127.0.0.1"), 9990);
    }

    public MBeanServerConnectionProvider(InetAddress hostAddr, int port) {
        this.hostAddr = hostAddr;
        this.port = port;
    }

    public MBeanServerConnection getConnection() {
        String host = this.hostAddr.getHostAddress();
        String urlString = System.getProperty("jmx.service.url", "service:jmx:remote+http://" + NetworkUtils.formatPossibleIpv6Address(host) + ":" + this.port);
        try {
            if (this.jmxConnector == null) {
                log.debug((Object)("Connecting JMXConnector to: " + urlString));
                JMXServiceURL serviceURL = new JMXServiceURL(urlString);
                this.jmxConnector = JMXConnectorFactory.connect(serviceURL, null);
            }
            return this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Cannot obtain MBeanServerConnection to: " + urlString, ex);
        }
    }

    public MBeanServerConnection getConnection(long timeout) {
        while (timeout > 0L) {
            try {
                return this.getConnection();
            }
            catch (Exception exception) {
                try {
                    Thread.sleep(100L);
                    timeout -= 100L;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        throw new IllegalStateException("MBeanServerConnection not available");
    }

    @Override
    public void close() throws IOException {
        IoUtils.safeClose((Closeable)this.jmxConnector);
    }
}

