/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed.setup;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.stream.Collectors;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.logging.Logger;
import org.wildfly.plugin.tools.server.ServerManager;
import org.wildfly.testing.tools.modules.ModuleDescription;

public abstract class CreateModuleServerSetupTask
implements ServerSetupTask {
    private static final Logger LOGGER = Logger.getLogger(CreateModuleServerSetupTask.class);
    private final Set<ModuleDescription> modules = new ConcurrentSkipListSet<ModuleDescription>();
    @ArquillianResource
    private ServerManager serverManager;

    public final void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.modules.addAll(this.moduleDescriptions());
        this.doSetup(managementClient, containerId, Set.copyOf(this.modules));
        this.serverManager.reloadIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        try {
            try (JMXConnector connector = CreateModuleServerSetupTask.createJmxConnector(managementClient);){
                CreateModuleServerSetupTask.unloadModule(connector.getMBeanServerConnection(), this.modules.stream().map(ModuleDescription::name).collect(Collectors.toSet()));
            }
            for (ModuleDescription module : this.modules) {
                module.close();
            }
        }
        finally {
            this.doTearDown(managementClient, containerId);
            this.serverManager.reloadIfRequired();
        }
    }

    protected void doSetup(ManagementClient managementClient, String containerId, Set<ModuleDescription> modules) throws Exception {
    }

    protected void doTearDown(ManagementClient managementClient, String containerId) throws Exception {
    }

    protected abstract Set<ModuleDescription> moduleDescriptions();

    private static void unloadModule(MBeanServerConnection connection, Set<String> moduleNames) throws MalformedObjectNameException, IOException, ReflectionException, InstanceNotFoundException, MBeanException {
        for (ObjectInstance mbean : connection.queryMBeans(ObjectName.getInstance("jboss.modules:type=ModuleLoader,name=*"), null)) {
            String[] info;
            for (String module : info = (String[])connection.invoke(mbean.getObjectName(), "queryLoadedModuleNames", null, null)) {
                if (!moduleNames.contains(module) || ((Boolean)connection.invoke(mbean.getObjectName(), "unloadModule", new Object[]{module}, new String[]{"java.lang.String"})).booleanValue()) continue;
                LOGGER.errorf("Failed to unload module: %s", (Object)module);
            }
        }
    }

    private static JMXConnector createJmxConnector(ManagementClient managementClient) throws IOException {
        Map<String, String> env = Map.of("org.jboss.remoting-jmx.timeout", "600");
        return JMXConnectorFactory.connect(managementClient.getRemoteJMXURL(), env);
    }
}

