/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.arquillian.protocol.jmx.TestDescription;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;

class ArquillianConfigBuilder {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");
    private static final String CLASS_NAME_JUNIT_RUNNER = "org.junit.runner.RunWith";
    private static final String CLASS_NAME_JUNIT5_RUNNER = "org.junit.jupiter.api.extension.ExtendWith";
    private static final String CLASS_NAME_TESTNG_RUNNER = "org.jboss.arquillian.testng.Arquillian";
    private static final DotName OPERATE_ON_DEPLOYMENT = DotName.createSimple((String)"org.jboss.arquillian.container.test.api.OperateOnDeployment");
    private static final AttachmentKey<Map<String, ArquillianConfig.TestClassInfo>> CLASSES = AttachmentKey.create(Map.class);

    ArquillianConfigBuilder() {
    }

    static Map<String, ArquillianConfig.TestClassInfo> getClasses(DeploymentUnit depUnit) {
        Map testClasses = (Map)depUnit.getAttachment(CLASSES);
        return testClasses == null || testClasses.isEmpty() ? null : testClasses;
    }

    static String getName(DeploymentUnit depUnit) {
        Object depUnitName = depUnit.getName();
        DeploymentUnit parent = depUnit.getParent();
        if (parent != null) {
            depUnitName = parent.getName() + "." + (String)depUnitName;
        }
        return depUnitName;
    }

    static void handleParseAnnotations(DeploymentUnit deploymentUnit) {
        CompositeIndex compositeIndex = (CompositeIndex)deploymentUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            log.warnf("Cannot find composite annotation index in: %s", (Object)deploymentUnit);
            return;
        }
        if (deploymentUnit.hasAttachment(CLASSES)) {
            return;
        }
        DotName runWithName = DotName.createSimple((String)CLASS_NAME_JUNIT_RUNNER);
        ArrayList runWithList = new ArrayList(compositeIndex.getAnnotations(runWithName));
        DotName extendWith = DotName.createSimple((String)CLASS_NAME_JUNIT5_RUNNER);
        runWithList.addAll(compositeIndex.getAnnotations(extendWith));
        DotName testNGClassName = DotName.createSimple((String)CLASS_NAME_TESTNG_RUNNER);
        Set testNgTests = compositeIndex.getAllKnownSubclasses(testNGClassName);
        LinkedHashMap<String, ArquillianConfig.TestClassInfo> testClasses = new LinkedHashMap<String, ArquillianConfig.TestClassInfo>();
        TestDescription testDescription = TestDescription.from(deploymentUnit);
        for (AnnotationInstance instance : runWithList) {
            AnnotationTarget target = instance.target();
            if (!(target instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)target;
            String testClassName = classInfo.name().toString();
            testClasses.put(testClassName, ArquillianConfigBuilder.getTestMethods(compositeIndex, classInfo, testDescription));
        }
        for (ClassInfo classInfo : testNgTests) {
            testClasses.put(classInfo.name().toString(), ArquillianConfigBuilder.getTestMethods(compositeIndex, classInfo, testDescription));
        }
        deploymentUnit.putAttachment(CLASSES, testClasses);
    }

    private static ArquillianConfig.TestClassInfo getTestMethods(CompositeIndex compositeIndex, ClassInfo classInfo, TestDescription testDescription) {
        HashSet<String> methods = new HashSet<String>();
        String deploymentName = testDescription.arquillianDeploymentName().orElse(null);
        ArquillianConfigBuilder.findAllMethods(compositeIndex, classInfo, deploymentName, methods);
        return new ArquillianConfig.TestClassInfo(testDescription, Set.copyOf(methods));
    }

    private static void findAllMethods(CompositeIndex compositeIndex, ClassInfo classInfo, String deploymentName, Set<String> methods) {
        if (classInfo == null) {
            return;
        }
        classInfo.methods().forEach(methodInfo -> {
            if (methodInfo.hasAnnotation(OPERATE_ON_DEPLOYMENT)) {
                AnnotationInstance annotation = methodInfo.annotation(OPERATE_ON_DEPLOYMENT);
                if (annotation.value().asString().equals(deploymentName)) {
                    methods.add(methodInfo.name());
                }
            } else {
                methods.add(methodInfo.name());
            }
        });
        if (classInfo.superName() != null && !classInfo.superName().toString().equals(Object.class.getName())) {
            ArquillianConfigBuilder.findAllMethods(compositeIndex, compositeIndex.getClassByName(classInfo.superName()), deploymentName, methods);
        }
        classInfo.interfaceNames().forEach(name -> ArquillianConfigBuilder.findAllMethods(compositeIndex, compositeIndex.getClassByName(name), deploymentName, methods));
    }
}

