/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.regex.Pattern;
import org.wildfly.channel.version.FixedVersionMatcher;
import org.wildfly.channel.version.VersionMatcher;
import org.wildfly.channel.version.VersionPatternMatcher;

public class Stream
implements Comparable<Stream> {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final Pattern versionPattern;
    private VersionMatcher versionMatcher;

    public Stream(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null);
    }

    public Stream(String groupId, String artifactId, Pattern versionPattern) {
        this(groupId, artifactId, null, versionPattern);
    }

    @JsonCreator
    public Stream(@JsonProperty(value="groupId", required=true) String groupId, @JsonProperty(value="artifactId", required=true) String artifactId, @JsonProperty(value="version") String version, @JsonProperty(value="versionPattern") Pattern versionPattern) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.versionPattern = versionPattern;
        this.validate();
        this.initVersionMatcher();
    }

    private void initVersionMatcher() {
        if (this.version != null) {
            this.versionMatcher = new FixedVersionMatcher(this.version);
        } else {
            Objects.requireNonNull(this.versionPattern);
            this.versionMatcher = new VersionPatternMatcher(this.versionPattern);
        }
    }

    private void validate() {
        if ("*".equals(this.groupId)) {
            throw new IllegalArgumentException(String.format("Invalid stream. the groupId does not accept wildcard '*'", new Object[0]));
        }
        if (this.version != null && this.versionPattern != null || this.version == null && this.versionPattern == null) {
            throw new IllegalArgumentException(String.format("Invalid stream. Only one of version, versionPattern field must be set", new Object[0]));
        }
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVersion() {
        return this.version;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Pattern getVersionPattern() {
        return this.versionPattern;
    }

    @JsonIgnore
    public VersionMatcher getVersionComparator() {
        return this.versionMatcher;
    }

    public String toString() {
        return "Stream{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', version='" + this.version + "', versionPattern=" + this.versionPattern + ", versionComparator=" + this.versionMatcher + "}";
    }

    @Override
    public int compareTo(Stream other) {
        int groupIdComp = this.groupId.compareTo(other.groupId);
        if (groupIdComp != 0) {
            return groupIdComp;
        }
        return this.artifactId.compareTo(other.artifactId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stream stream = (Stream)o;
        return this.groupId.equals(stream.groupId) && this.artifactId.equals(stream.artifactId) && this.version.equals(stream.version) && Objects.equals(this.versionPattern, stream.versionPattern);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version, this.versionPattern);
    }
}

