/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.wildfly.channel.BlocklistEntry;
import org.wildfly.channel.ChannelMapper;
import org.wildfly.channel.InvalidChannelMetadataException;

public class Blocklist {
    public static final String SCHEMA_VERSION_1_0_0 = "1.0.0";
    private static final String SCHEMA_1_0_0_FILE = "org/wildfly/blocklist/v1.0.0/schema.json";
    private static final YAMLFactory YAML_FACTORY = new YAMLFactory().configure(YAMLGenerator.Feature.INDENT_ARRAYS_WITH_INDICATOR, true);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper((JsonFactory)YAML_FACTORY).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
    private static final JsonSchemaFactory SCHEMA_FACTORY = JsonSchemaFactory.builder((JsonSchemaFactory)JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V201909)).jsonMapper(OBJECT_MAPPER).build();
    private static final Map<String, JsonSchema> SCHEMAS = new HashMap<String, JsonSchema>();
    private final String schemaVersion;
    private Set<BlocklistEntry> entries;

    @JsonCreator
    public Blocklist(@JsonProperty(value="schemaVersion", required=true) String schemaVersion, @JsonProperty(value="blocks") Set<BlocklistEntry> entries) {
        this.schemaVersion = schemaVersion;
        this.entries = entries;
    }

    public static Blocklist from(URL blocklistUrl) {
        Objects.requireNonNull(blocklistUrl);
        try {
            List<String> messages;
            if (blocklistUrl.toString().endsWith("/")) {
                blocklistUrl = blocklistUrl.toURI().resolve("blocklist.yaml").toURL();
            }
            if (!(messages = Blocklist.validate(blocklistUrl)).isEmpty()) {
                throw new InvalidChannelMetadataException("Invalid blocklist", messages);
            }
            Blocklist blocklist = (Blocklist)OBJECT_MAPPER.readValue(blocklistUrl, Blocklist.class);
            return blocklist;
        }
        catch (IOException | URISyntaxException e) {
            throw Blocklist.wrapException(e);
        }
    }

    private static InvalidChannelMetadataException wrapException(Exception e) {
        InvalidChannelMetadataException ice = new InvalidChannelMetadataException("Invalid Channel", Collections.singletonList(e.getLocalizedMessage()));
        ice.initCause(e);
        return ice;
    }

    public Set<String> getVersionsFor(String groupId, String artifactId) {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        if (this.entries == null) {
            return Collections.emptySet();
        }
        for (BlocklistEntry entry : this.entries) {
            if (!entry.getGroupId().equals(groupId) || !entry.getArtifactId().equals(artifactId)) continue;
            return entry.getVersions();
        }
        for (BlocklistEntry entry : this.entries) {
            if (!entry.getGroupId().equals(groupId) || !entry.getArtifactId().equals("*")) continue;
            return entry.getVersions();
        }
        return Collections.emptySet();
    }

    private static List<String> validate(URL url) throws IOException {
        JsonNode node = OBJECT_MAPPER.readTree(url);
        JsonSchema schema = Blocklist.getSchema(node);
        schema.initializeValidators();
        Set validationMessages = schema.validate(node);
        return validationMessages.stream().map(ValidationMessage::getMessage).collect(Collectors.toList());
    }

    private static JsonSchema getSchema(JsonNode node) {
        JsonNode schemaVersion = node.path("schemaVersion");
        String version = schemaVersion.asText();
        if (version == null || version.isEmpty()) {
            throw new InvalidChannelMetadataException("Invalid Manifest", List.of("The manifest does not specify a schemaVersion."));
        }
        JsonSchema schema = SCHEMAS.get(version);
        if (schema == null) {
            throw new InvalidChannelMetadataException("Invalid Manifest", List.of("Unknown schema version " + schemaVersion));
        }
        return schema;
    }

    public String toString() {
        return "Blocklist{schemaVersion='" + this.schemaVersion + "', entries=" + this.entries + "}";
    }

    static {
        SCHEMAS.put(SCHEMA_VERSION_1_0_0, SCHEMA_FACTORY.getSchema(ChannelMapper.class.getClassLoader().getResourceAsStream(SCHEMA_1_0_0_FILE)));
    }
}

