/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.channel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

public class MavenCoordinate {
    private String groupId;
    private String artifactId;
    private String version;

    @JsonCreator
    public MavenCoordinate(@JsonProperty(value="groupId", required=true) String groupId, @JsonProperty(value="artifactId", required=true) String artifactId, @JsonProperty(value="version") String version) {
        Objects.requireNonNull(groupId);
        Objects.requireNonNull(artifactId);
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return "MavenCoordinate{groupId='" + this.groupId + "', artifactId='" + this.artifactId + "', version='" + this.version + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenCoordinate that = (MavenCoordinate)o;
        return Objects.equals(this.groupId, that.groupId) && Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        return Objects.hash(this.groupId, this.artifactId, this.version);
    }
}

