/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.accesscontrol.AccessRequirement;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.wildfly.common.Assert;

public class ArgumentWithoutValue
implements CommandArgument {
    protected final int index;
    protected final String fullName;
    protected final String shortName;
    protected List<CommandArgument> requiredPreceding;
    protected List<CommandArgument> cantAppearAfter = Collections.emptyList();
    protected boolean exclusive;
    protected AccessRequirement access = AccessRequirement.NONE;

    public ArgumentWithoutValue(CommandHandlerWithArguments handler, String fullName) {
        this(handler, -1, fullName);
    }

    public ArgumentWithoutValue(CommandHandlerWithArguments handler, String fullName, String shortName) {
        Assert.checkNotNullParam("handler", handler);
        this.fullName = Assert.checkNotEmptyParam("fullName", fullName);
        this.shortName = shortName;
        this.index = -1;
        handler.addArgument(this);
    }

    public ArgumentWithoutValue(CommandHandlerWithArguments handler, int index, String fullName) {
        Assert.checkNotNullParam("handler", handler);
        this.fullName = Assert.checkNotEmptyParam("fullName", fullName);
        this.shortName = null;
        this.index = index;
        handler.addArgument(this);
    }

    public void setExclusive(boolean exclusive) {
        this.exclusive = exclusive;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public void addRequiredPreceding(CommandArgument arg) {
        Assert.checkNotNullParam("arg", arg);
        if (this.requiredPreceding == null) {
            this.requiredPreceding = Collections.singletonList(arg);
            return;
        }
        if (this.requiredPreceding.size() == 1) {
            this.requiredPreceding = new ArrayList<CommandArgument>(this.requiredPreceding);
        }
        this.requiredPreceding.add(arg);
    }

    public void addCantAppearAfter(CommandArgument arg) {
        if (this.cantAppearAfter.isEmpty()) {
            this.cantAppearAfter = new ArrayList<CommandArgument>();
        }
        this.cantAppearAfter.add(arg);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public CommandLineCompleter getValueCompleter() {
        return null;
    }

    @Override
    public String getValue(ParsedCommandLine args) {
        try {
            return this.getValue(args, false);
        }
        catch (CommandFormatException e) {
            return null;
        }
    }

    @Override
    public String getValue(ParsedCommandLine args, boolean required) throws CommandFormatException {
        if (!required) {
            return null;
        }
        if (this.isPresent(args)) {
            return null;
        }
        throw new CommandFormatException("Required argument '" + this.fullName + "' is missing value.");
    }

    @Override
    public boolean isPresent(ParsedCommandLine args) throws CommandFormatException {
        if (!args.hasProperties()) {
            return false;
        }
        if (this.index >= 0 && this.index < args.getOtherProperties().size()) {
            return true;
        }
        if (args.hasProperty(this.fullName)) {
            return true;
        }
        return this.shortName != null && args.hasProperty(this.shortName);
    }

    @Override
    public boolean isValueComplete(ParsedCommandLine args) throws CommandFormatException {
        if (args.hasProperty(this.fullName)) {
            return true;
        }
        return this.shortName != null && args.hasProperty(this.shortName);
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
        if (!this.access.isSatisfied(ctx)) {
            return false;
        }
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (this.exclusive) {
            Set<String> propertyNames = args.getPropertyNames();
            if (propertyNames.isEmpty()) {
                List<String> values = args.getOtherProperties();
                if (values.isEmpty()) {
                    return true;
                }
                if (this.index == -1) {
                    return false;
                }
                return this.index != 0 || values.size() != 1;
            }
            if (propertyNames.size() != 1) {
                return false;
            }
            if (args.getLastParsedPropertyName() == null) {
                return false;
            }
            List<String> values = args.getOtherProperties();
            if (!values.isEmpty()) {
                return false;
            }
            if (this.fullName.equals(args.getLastParsedPropertyName())) {
                return false;
            }
            return this.fullName.startsWith(args.getLastParsedPropertyName()) || this.shortName != null && this.shortName.startsWith(args.getLastParsedPropertyName());
        }
        if (this.isPresent(args)) {
            return false;
        }
        for (CommandArgument arg : this.cantAppearAfter) {
            if (!arg.isPresent(args)) continue;
            return false;
        }
        if (this.requiredPreceding != null) {
            for (CommandArgument arg : this.requiredPreceding) {
                if (!arg.isPresent(args)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isValueRequired() {
        return false;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public void setAccessRequirement(AccessRequirement access) {
        this.access = Assert.checkNotNullParam("access", access);
    }
}

