/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinition;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.Action;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class XmlMarshallingHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "read-config-as-xml";
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("read-config-as-xml", ControllerResolver.getResolver(new String[0])).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).setReplyType(ModelType.STRING).setReadOnly().setRuntimeOnly().build();
    private static final Set<Action.ActionEffect> EFFECTS = Collections.unmodifiableSet(EnumSet.of(Action.ActionEffect.ADDRESS, Action.ActionEffect.READ_CONFIG));
    private final ConfigurationPersister configPersister;

    public XmlMarshallingHandler(ConfigurationPersister configPersister) {
        this.configPersister = configPersister;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(OperationContext context, ModelNode operation) {
        PathAddress pa = context.getCurrentAddress();
        AuthorizationResult authResult = context.authorize(operation, EFFECTS);
        if (authResult.getDecision() != AuthorizationResult.Decision.PERMIT) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.require("operation").asString(), pa, authResult.getExplanation());
        }
        Resource resource = context.readResourceFromRoot(this.getBaseAddress());
        ModelNode model = Resource.Tools.readModel(resource);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                BufferedOutputStream output = new BufferedOutputStream(baos);
                this.configPersister.marshallAsXml(model, output);
                output.close();
                baos.close();
            }
            finally {
                this.safeClose(baos);
            }
            String xml = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            context.getResult().set(xml);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            ControllerLogger.MGMT_OP_LOGGER.failedExecutingOperation(e, operation.require("operation"), pa);
            context.getFailureDescription().set(e.toString());
        }
    }

    protected PathAddress getBaseAddress() {
        return PathAddress.EMPTY_ADDRESS;
    }

    private void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                ControllerLogger.MGMT_OP_LOGGER.failedToCloseResource(t, closeable);
            }
        }
    }
}

