/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.CapabilityReferenceRecorder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDescriptor;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class AbstractAddStepHandler
implements OperationStepHandler,
OperationDescriptor {
    protected final Collection<? extends AttributeDefinition> attributes;

    public AbstractAddStepHandler() {
        this.attributes = List.of();
    }

    public AbstractAddStepHandler(Collection<? extends AttributeDefinition> attributes) {
        this.attributes = attributes instanceof Set ? Set.copyOf((Set)attributes) : List.copyOf(attributes);
    }

    public AbstractAddStepHandler(AttributeDefinition ... attributes) {
        this(List.of(attributes));
    }

    public AbstractAddStepHandler(Parameters parameters) {
        this.attributes = parameters.attributes;
    }

    @Override
    public Collection<? extends AttributeDefinition> getAttributes() {
        return this.attributes;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final Resource resource = this.createResource(context, operation);
        this.populateModel(context, operation, resource);
        this.recordCapabilitiesAndRequirements(context, operation, resource);
        if (this.requiresRuntime(context)) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    AbstractAddStepHandler.this.performRuntime(context, operation, resource);
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            AbstractAddStepHandler.this.rollbackRuntime(context, operation, resource);
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }

    protected Resource createResource(OperationContext context, ModelNode operation) {
        ImmutableManagementResourceRegistration registration = context.getResourceRegistration();
        if (registration != null) {
            Set<String> orderedChildTypes = registration.getOrderedChildTypes();
            boolean orderedChildResource = registration.isOrderedChildResource();
            if (orderedChildResource || !orderedChildTypes.isEmpty()) {
                return new OrderedResourceCreator(orderedChildResource, orderedChildTypes).createResource(context, operation);
            }
        }
        return this.createResource(context);
    }

    protected Resource createResource(OperationContext context) {
        return context.createResource(PathAddress.EMPTY_ADDRESS);
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource);
    }

    protected void populateModel(ModelNode operation, Resource resource) throws OperationFailedException {
        this.populateModel(operation, resource.getModel());
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attributeDefinition : this.attributes) {
            attributeDefinition.validateAndSet(operation, model);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        for (RuntimeCapability runtimeCapability : context.getResourceRegistration().getCapabilities()) {
            if (runtimeCapability.isDynamicallyNamed()) {
                context.registerCapability(runtimeCapability.fromBaseCapability(context.getCurrentAddress()));
                continue;
            }
            context.registerCapability(runtimeCapability);
        }
        ModelNode model = resource.getModel();
        for (AttributeDefinition attributeDefinition : this.attributes) {
            if (!model.hasDefined(attributeDefinition.getName()) && !attributeDefinition.hasCapabilityRequirements()) continue;
            attributeDefinition.addCapabilityRequirements(context, resource, model.get(attributeDefinition.getName()));
        }
        ImmutableManagementResourceRegistration immutableManagementResourceRegistration = context.getResourceRegistration();
        assert (immutableManagementResourceRegistration.getRequirements() != null);
        for (CapabilityReferenceRecorder recorder : immutableManagementResourceRegistration.getRequirements()) {
            recorder.addCapabilityRequirements(context, resource, null, new String[0]);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.isDefaultRequiresRuntime();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        this.performRuntime(context, operation, resource.getModel());
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
    }

    private static class ImmutableListSet<T>
    extends AbstractSet<T> {
        private final List<T> list;

        ImmutableListSet(List<T> list) {
            this.list = list;
        }

        @Override
        public int size() {
            return this.list.size();
        }

        @Override
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }
    }

    public static class Parameters {
        protected Set<AttributeDefinition> attributes = Set.of();

        public Parameters addAttribute(AttributeDefinition ... attributes) {
            return this.addAttribute(List.of(attributes));
        }

        public Parameters addAttribute(Collection<? extends AttributeDefinition> attributes) {
            if (this.attributes.isEmpty()) {
                this.attributes = attributes instanceof List ? new ImmutableListSet<AttributeDefinition>(List.copyOf(attributes)) : Set.copyOf(attributes);
            } else {
                ArrayList<? extends AttributeDefinition> newAttributes = new ArrayList<AttributeDefinition>(this.attributes.size() + attributes.size());
                newAttributes.addAll(this.attributes);
                newAttributes.addAll(attributes);
                this.attributes = new ImmutableListSet(newAttributes);
            }
            return this;
        }
    }

    private static class OrderedResourceCreator
    implements ResourceCreator {
        private final Set<String> orderedChildTypes;
        private final boolean indexedAdd;

        public OrderedResourceCreator(boolean indexedAdd, Set<String> orderedChildTypes) {
            this.indexedAdd = indexedAdd;
            this.orderedChildTypes = orderedChildTypes == null ? Collections.emptySet() : orderedChildTypes;
        }

        public OrderedResourceCreator(boolean indexedAdd, String ... orderedChildTypes) {
            this.indexedAdd = indexedAdd;
            HashSet<String> set = new HashSet<String>(orderedChildTypes.length);
            set.addAll(Arrays.asList(orderedChildTypes));
            this.orderedChildTypes = set;
        }

        @Override
        public Resource createResource(OperationContext context, ModelNode operation) {
            Resource resource = Resource.Factory.create(false, this.orderedChildTypes);
            int index = -1;
            if (this.indexedAdd && operation.hasDefined("add-index")) {
                index = operation.get("add-index").asInt();
            }
            if (index >= 0) {
                context.addResource(PathAddress.EMPTY_ADDRESS, operation.get("add-index").asInt(), resource);
            } else {
                context.addResource(PathAddress.EMPTY_ADDRESS, resource);
            }
            return resource;
        }
    }

    private static interface ResourceCreator {
        public Resource createResource(OperationContext var1, ModelNode var2);
    }
}

