/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.StringListAttributeDefinition;
import org.jboss.as.controller.access.AuthorizerConfiguration;
import org.jboss.as.controller.access.CombinationPolicy;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.AccessConstraintUtilizationRegistry;
import org.jboss.as.controller.access.management.DelegatingConfigurableAuthorizer;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.domain.management._private.DomainManagementResolver;
import org.jboss.as.domain.management.access.AccessAuthorizationCombinationPolicyWriteAttributeHandler;
import org.jboss.as.domain.management.access.AccessAuthorizationDomainSlaveConfigHandler;
import org.jboss.as.domain.management.access.AccessAuthorizationProviderWriteAttributeHandler;
import org.jboss.as.domain.management.access.AccessAuthorizationRolesHandler;
import org.jboss.as.domain.management.access.AccessAuthorizationUseIdentityRolesWriteAttributeHandler;
import org.jboss.as.domain.management.access.AccessConstraintResources;
import org.jboss.as.domain.management.access.ApplicationClassificationParentResourceDefinition;
import org.jboss.as.domain.management.access.HostScopedRolesResourceDefinition;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityClassificationParentResourceDefinition;
import org.jboss.as.domain.management.access.SensitivityResourceDefinition;
import org.jboss.as.domain.management.access.ServerGroupScopedRoleResourceDefinition;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class AccessAuthorizationResourceDefinition
extends SimpleResourceDefinition {
    public static final PathElement PATH_ELEMENT = PathElement.pathElement((String)"access", (String)"authorization");
    public static final SimpleAttributeDefinition PERMISSION_COMBINATION_POLICY = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("permission-combination-policy", ModelType.STRING, true).setDefaultValue(new ModelNode(CombinationPolicy.PERMISSIVE.toString()))).setValidator((ParameterValidator)EnumValidator.create(CombinationPolicy.class, (Enum[])new CombinationPolicy[0]))).build();
    public static final SimpleAttributeDefinition PROVIDER = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("provider", ModelType.STRING, true).setDefaultValue(new ModelNode(Provider.SIMPLE.toString()))).setValidator((ParameterValidator)EnumValidator.create(Provider.class, (Enum[])new Provider[0]))).build();
    public static final SimpleAttributeDefinition USE_IDENTITY_ROLES = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("use-identity-roles", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.FALSE)).build();
    static final ListAttributeDefinition STANDARD_ROLE_NAMES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("standard-role-names").setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    static final ListAttributeDefinition ALL_ROLE_NAMES = ((StringListAttributeDefinition.Builder)((StringListAttributeDefinition.Builder)new StringListAttributeDefinition.Builder("all-role-names").setStorageRuntime()).setRuntimeServiceNotRequired()).build();
    public static final List<AttributeDefinition> CONFIG_ATTRIBUTES = Arrays.asList(PROVIDER, PERMISSION_COMBINATION_POLICY);
    private final DelegatingConfigurableAuthorizer configurableAuthorizer;
    private final boolean isDomain;

    public static AccessAuthorizationResourceDefinition forDomain(DelegatingConfigurableAuthorizer configurableAuthorizer) {
        return new AccessAuthorizationResourceDefinition(configurableAuthorizer, true);
    }

    public static AccessAuthorizationResourceDefinition forDomainServer(DelegatingConfigurableAuthorizer configurableAuthorizer) {
        return new AccessAuthorizationResourceDefinition(configurableAuthorizer, true);
    }

    public static AccessAuthorizationResourceDefinition forStandaloneServer(DelegatingConfigurableAuthorizer configurableAuthorizer) {
        return new AccessAuthorizationResourceDefinition(configurableAuthorizer, false);
    }

    private AccessAuthorizationResourceDefinition(DelegatingConfigurableAuthorizer configurableAuthorizer, boolean domain) {
        super(new SimpleResourceDefinition.Parameters(PATH_ELEMENT, DomainManagementResolver.getResolver("core.access-control")).setAccessConstraints(new AccessConstraintDefinition[]{SensitiveTargetAccessConstraintDefinition.ACCESS_CONTROL}));
        this.configurableAuthorizer = configurableAuthorizer;
        this.isDomain = domain;
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        WritableAuthorizerConfiguration authorizerConfiguration = this.configurableAuthorizer.getWritableAuthorizerConfiguration();
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PROVIDER, null, (OperationStepHandler)new AccessAuthorizationProviderWriteAttributeHandler(this.configurableAuthorizer));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)USE_IDENTITY_ROLES, null, (OperationStepHandler)new AccessAuthorizationUseIdentityRolesWriteAttributeHandler(this.configurableAuthorizer.getWritableAuthorizerConfiguration()));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PERMISSION_COMBINATION_POLICY, null, (OperationStepHandler)new AccessAuthorizationCombinationPolicyWriteAttributeHandler(authorizerConfiguration));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)STANDARD_ROLE_NAMES, (OperationStepHandler)AccessAuthorizationRolesHandler.getStandardRolesHandler((AuthorizerConfiguration)authorizerConfiguration));
        resourceRegistration.registerReadOnlyAttribute((AttributeDefinition)ALL_ROLE_NAMES, (OperationStepHandler)AccessAuthorizationRolesHandler.getAllRolesHandler((AuthorizerConfiguration)authorizerConfiguration));
    }

    public void registerChildren(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerSubModel((ResourceDefinition)RoleMappingResourceDefinition.create(this.configurableAuthorizer, this.isDomain));
        if (this.isDomain) {
            WritableAuthorizerConfiguration authorizerConfiguration = this.configurableAuthorizer.getWritableAuthorizerConfiguration();
            resourceRegistration.registerSubModel((ResourceDefinition)new ServerGroupScopedRoleResourceDefinition(authorizerConfiguration));
            resourceRegistration.registerSubModel((ResourceDefinition)new HostScopedRolesResourceDefinition(authorizerConfiguration));
        }
        resourceRegistration.registerSubModel((ResourceDefinition)ApplicationClassificationParentResourceDefinition.INSTANCE);
        resourceRegistration.registerSubModel((ResourceDefinition)SensitivityClassificationParentResourceDefinition.INSTANCE);
        resourceRegistration.registerSubModel((ResourceDefinition)SensitivityResourceDefinition.createVaultExpressionConfiguration());
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        if (this.isDomain) {
            resourceRegistration.registerOperationHandler(AccessAuthorizationDomainSlaveConfigHandler.DEFINITION, (OperationStepHandler)new AccessAuthorizationDomainSlaveConfigHandler(this.configurableAuthorizer));
        }
    }

    public static Resource createResource(AccessConstraintUtilizationRegistry registry) {
        Resource accessControlRoot = Resource.Factory.create();
        accessControlRoot.registerChild(AccessConstraintResources.APPLICATION_PATH_ELEMENT, AccessConstraintResources.getApplicationConfigResource(registry));
        accessControlRoot.registerChild(AccessConstraintResources.SENSITIVITY_PATH_ELEMENT, AccessConstraintResources.getSensitivityResource(registry));
        accessControlRoot.registerChild(AccessConstraintResources.VAULT_PATH_ELEMENT, AccessConstraintResources.VAULT_RESOURCE);
        return accessControlRoot;
    }

    public static enum Provider {
        SIMPLE("simple"),
        RBAC("rbac");

        private final String toString;

        private Provider(String toString) {
            this.toString = toString;
        }

        public String toString() {
            return this.toString;
        }
    }
}

