/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.access;

import java.util.Locale;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.access.management.WritableAuthorizerConfiguration;
import org.jboss.as.domain.management.access.RoleMappingResourceDefinition;
import org.jboss.dmr.ModelNode;

public class RoleIncludeAllWriteAttributeHandler
extends AbstractWriteAttributeHandler<Void> {
    private final WritableAuthorizerConfiguration authorizerConfiguration;

    RoleIncludeAllWriteAttributeHandler(WritableAuthorizerConfiguration authorizerConfiguration) {
        super(new AttributeDefinition[]{RoleMappingResourceDefinition.INCLUDE_ALL});
        this.authorizerConfiguration = authorizerConfiguration;
    }

    protected boolean requiresRuntime(OperationContext context) {
        return !context.isBooting();
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> handbackHolder) throws OperationFailedException {
        String roleName = RoleMappingResourceDefinition.getRoleName(operation);
        this.authorizerConfiguration.setRoleMappingIncludeAll(roleName.toUpperCase(Locale.ENGLISH), resolvedValue.asBoolean());
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, Void handback) throws OperationFailedException {
        String roleName = RoleMappingResourceDefinition.getRoleName(operation);
        this.authorizerConfiguration.setRoleMappingIncludeAll(roleName, valueToRestore.asBoolean());
    }
}

