/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime._private;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.jboss.as.version.Stability;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleLoader;
import org.wildfly.core.jar.runtime._private.BootableJarLogger;

public class BootableJarLogger_$logger
extends DelegatingBasicLogger
implements BootableJarLogger,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = BootableJarLogger_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public BootableJarLogger_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void shuttingDown() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.shuttingDown$str(), new Object[0]);
    }

    protected String shuttingDown$str() {
        return "WFLYJAR0001: Shutting down";
    }

    @Override
    public final void serverStopped() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.serverStopped$str(), new Object[0]);
    }

    protected String serverStopped$str() {
        return "WFLYJAR0002: Server stopped, exiting";
    }

    @Override
    public final void serverNotStopped() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.serverNotStopped$str(), new Object[0]);
    }

    protected String serverNotStopped$str() {
        return "WFLYJAR0003: Server not yet stopped, waiting";
    }

    @Override
    public final void nullController() {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.nullController$str(), new Object[0]);
    }

    protected String nullController$str() {
        return "WFLYJAR0004: Null controller client, exiting";
    }

    protected String unexpectedExceptionWhileShuttingDown$str() {
        return "WFLYJAR0005: Unexpected exception while shutting down server";
    }

    @Override
    public final RuntimeException unexpectedExceptionWhileShuttingDown(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unexpectedExceptionWhileShuttingDown$str(), new Object[0]), cause);
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void installDeployment(Path dep) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.installDeployment$str(), (Object)dep);
    }

    protected String installDeployment$str() {
        return "WFLYJAR0006: Deployed %s in server";
    }

    @Override
    public final void advertiseInstall(Path home, long duration) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.advertiseInstall$str(), (Object)home, (Object)duration);
    }

    protected String advertiseInstall$str() {
        return "WFLYJAR0007: Installed server and application in %s, took %sms";
    }

    @Override
    public final void advertiseOptions(List<String> options) {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.advertiseOptions$str(), options);
    }

    protected String advertiseOptions$str() {
        return "WFLYJAR0008: Server options: %s";
    }

    @Override
    public final void deletingHome(Path dep) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.deletingHome$str(), (Object)dep);
    }

    protected String deletingHome$str() {
        return "WFLYJAR0009: Deleting %s dir";
    }

    protected String deploymentAlreadyExist$str() {
        return "WFLYJAR0010: Not an hollow jar, deployment already exists";
    }

    @Override
    public final Exception deploymentAlreadyExist() {
        Exception result = new Exception(String.format(this.getLoggingLocale(), this.deploymentAlreadyExist$str(), new Object[0]));
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String unknownArgument$str() {
        return "WFLYJAR0011: Unknown argument %s";
    }

    @Override
    public final RuntimeException unknownArgument(String arg) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.unknownArgument$str(), arg));
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String notExistingFile$str() {
        return "WFLYJAR0012: File %s doesn't exist";
    }

    @Override
    public final RuntimeException notExistingFile(String file) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.notExistingFile$str(), file));
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String invalidArgument$str() {
        return "WFLYJAR0013: Invalid argument %s, no value provided";
    }

    @Override
    public final RuntimeException invalidArgument(String arg) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.invalidArgument$str(), arg));
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String processIsStopping$str() {
        return "WFLYJAR0014: The server is stopping and invocations on the ModelControllerClient are not available";
    }

    @Override
    public final IllegalStateException processIsStopping() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.processIsStopping$str(), new Object[0]));
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String processIsReloading$str() {
        return "WFLYJAR0015: The server is reloading and invocations on the ModelControllerClient are not yet available";
    }

    @Override
    public final IllegalStateException processIsReloading() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.processIsReloading$str(), new Object[0]));
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String processIsStopped$str() {
        return "WFLYJAR0016: The server is stopped and invocations on the ModelControllerClient are not available";
    }

    @Override
    public final IllegalStateException processIsStopped() {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.processIsStopped$str(), new Object[0]));
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cannotStartServer$str() {
        return "WFLYJAR0017: Cannot start server";
    }

    @Override
    public final RuntimeException cannotStartServer(Throwable cause) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.cannotStartServer$str(), new Object[0]), cause);
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String moduleLoaderError$str() {
        return "WFLYJAR0018: Cannot load module %s from: %s";
    }

    @Override
    public final RuntimeException moduleLoaderError(Throwable cause, String msg, ModuleLoader moduleLoader) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.moduleLoaderError$str(), msg, moduleLoader), cause);
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void cantRestartServer() {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cantRestartServer$str(), new Object[0]);
    }

    protected String cantRestartServer$str() {
        return "WFLYJAR0019: Cannot restart server, exiting";
    }

    @Override
    public final void cantDelete(String path, IOException ioex) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cantDelete$str(), (Object)path, (Object)ioex);
    }

    protected String cantDelete$str() {
        return "WFLYJAR0020: Can't delete %s. Exception %s";
    }

    @Override
    public final void cantRegisterModuleMBeans(Exception ex) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cantRegisterModuleMBeans$str(), (Object)ex);
    }

    protected String cantRegisterModuleMBeans$str() {
        return "WFLYJAR0021: Cannot register JBoss Modules MBeans, %s";
    }

    protected String pidFileAlreadyExists$str() {
        return "WFLYJAR0022: The PID file %s already exists. This may result in the install directory \"%s\" not being properly deleted.";
    }

    @Override
    public final IllegalStateException pidFileAlreadyExists(Path pidFile, Path installDir) {
        IllegalStateException result = new IllegalStateException(String.format(this.getLoggingLocale(), this.pidFileAlreadyExists$str(), pidFile, installDir));
        BootableJarLogger_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void failedToStartCleanupProcess(Throwable cause, Path installDir) {
        this.log.logf(FQCN, Logger.Level.WARN, cause, this.failedToStartCleanupProcess$str(), (Object)installDir);
    }

    protected String failedToStartCleanupProcess$str() {
        return "WFLYJAR0023: Failed to start the cleanup processor. This may result in the install directory \"%s\" not being properly deleted.";
    }

    @Override
    public final void cleanupTimeout(long timeout, Path installDir) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.cleanupTimeout$str(), (Object)timeout, (Object)installDir);
    }

    protected String cleanupTimeout$str() {
        return "WFLYJAR0024: The container has not properly shutdown within %ds. This may result in the install directory \"%s\" not being properly deleted.";
    }

    protected String argPublicBindAddress$str() {
        return "Set system property jboss.bind.address to the given value";
    }

    @Override
    public final String argPublicBindAddress() {
        return String.format(this.getLoggingLocale(), this.argPublicBindAddress$str(), new Object[0]);
    }

    protected String argInterfaceBindAddress$str() {
        return "Set system property jboss.bind.address.<interface> to the given value";
    }

    @Override
    public final String argInterfaceBindAddress() {
        return String.format(this.getLoggingLocale(), this.argInterfaceBindAddress$str(), new Object[0]);
    }

    protected String argSystem$str() {
        return "Set a system property";
    }

    @Override
    public final String argSystem() {
        return String.format(this.getLoggingLocale(), this.argSystem$str(), new Object[0]);
    }

    protected String argHelp$str() {
        return "Display this message and exit";
    }

    @Override
    public final String argHelp() {
        return String.format(this.getLoggingLocale(), this.argHelp$str(), new Object[0]);
    }

    protected String argProperties$str() {
        return "Load system properties from the given url";
    }

    @Override
    public final String argProperties() {
        return String.format(this.getLoggingLocale(), this.argProperties$str(), new Object[0]);
    }

    protected String argDefaultMulticastAddress$str() {
        return "Set system property jboss.default.multicast.address to the given value";
    }

    @Override
    public final String argDefaultMulticastAddress() {
        return String.format(this.getLoggingLocale(), this.argDefaultMulticastAddress$str(), new Object[0]);
    }

    protected String argVersion$str() {
        return "Print version and exit";
    }

    @Override
    public final String argVersion() {
        return String.format(this.getLoggingLocale(), this.argVersion$str(), new Object[0]);
    }

    protected String argSecurityManager$str() {
        return "Activate the SecurityManager";
    }

    @Override
    public final String argSecurityManager() {
        return String.format(this.getLoggingLocale(), this.argSecurityManager$str(), new Object[0]);
    }

    protected String argStability$str() {
        return "Runs the server using a specific stability level. Possible values: %s, Default = %s";
    }

    @Override
    public final String argStability(Set<Stability> levels, Stability defaultLevel) {
        return String.format(this.getLoggingLocale(), this.argStability$str(), levels, defaultLevel);
    }

    protected String argSecurityProperty$str() {
        return "Set a security property";
    }

    @Override
    public final String argSecurityProperty() {
        return String.format(this.getLoggingLocale(), this.argSecurityProperty$str(), new Object[0]);
    }

    protected String argDeployment$str() {
        return "Path to deployment artifact (war,jar,ear or exploded deployment dir) to deploy in hollow jar";
    }

    @Override
    public final String argDeployment() {
        return String.format(this.getLoggingLocale(), this.argDeployment$str(), new Object[0]);
    }

    protected String argInstallation$str() {
        return "Path to directory in which the server is installed. By default the server is installed in TEMP directory.";
    }

    @Override
    public final String argInstallation() {
        return String.format(this.getLoggingLocale(), this.argInstallation$str(), new Object[0]);
    }

    protected String argDisplayGalleonConfig$str() {
        return "Display the content of the Galleon configuration used to build this bootable JAR";
    }

    @Override
    public final String argDisplayGalleonConfig() {
        return String.format(this.getLoggingLocale(), this.argDisplayGalleonConfig$str(), new Object[0]);
    }

    protected String argCliScript$str() {
        return "Path to a CLI script to execute when starting the Bootable JAR";
    }

    @Override
    public final String argCliScript() {
        return String.format(this.getLoggingLocale(), this.argCliScript$str(), new Object[0]);
    }

    @Override
    public final void securityProviderFailed(Throwable ex) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.securityProviderFailed$str(), (Object)ex);
    }

    protected String securityProviderFailed$str() {
        return "WFLYJAR0025: Failed to initialize a security provider. Reason: %s";
    }
}

