/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jmx;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.jboss.as.controller.AccessAuditContext;
import org.jboss.as.controller.access.Caller;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    private SecurityActions() {
    }

    static AccessAuditContext currentAccessAuditContext() {
        return SecurityActions.createAccessAuditContextActions().currentContext();
    }

    static Caller createCaller() {
        AccessControlContext acc = AccessController.getContext();
        return SecurityActions.createCallerActions().createCaller(acc);
    }

    private static AccessAuditContextActions createAccessAuditContextActions() {
        return WildFlySecurityManager.isChecking() ? AccessAuditContextActions.PRIVILEGED : AccessAuditContextActions.NON_PRIVILEGED;
    }

    private static CallerActions createCallerActions() {
        return WildFlySecurityManager.isChecking() ? CallerActions.PRIVILEGED : CallerActions.NON_PRIVILEGED;
    }

    private static interface CallerActions {
        public static final CallerActions NON_PRIVILEGED = new CallerActions(){

            @Override
            public Caller createCaller(AccessControlContext acc) {
                Subject subject = Subject.getSubject(acc);
                return Caller.createCaller((Subject)subject);
            }
        };
        public static final CallerActions PRIVILEGED = new CallerActions(){

            @Override
            public Caller createCaller(final AccessControlContext acc) {
                return AccessController.doPrivileged(new PrivilegedAction<Caller>(){

                    @Override
                    public Caller run() {
                        return NON_PRIVILEGED.createCaller(acc);
                    }
                });
            }
        };

        public Caller createCaller(AccessControlContext var1);
    }

    private static interface AccessAuditContextActions {
        public static final AccessAuditContextActions NON_PRIVILEGED = new AccessAuditContextActions(){

            @Override
            public AccessAuditContext currentContext() {
                return AccessAuditContext.currentAccessAuditContext();
            }
        };
        public static final AccessAuditContextActions PRIVILEGED = new AccessAuditContextActions(){
            private final PrivilegedAction<AccessAuditContext> PRIVILEGED_ACTION = new PrivilegedAction<AccessAuditContext>(){

                @Override
                public AccessAuditContext run() {
                    return NON_PRIVILEGED.currentContext();
                }
            };

            @Override
            public AccessAuditContext currentContext() {
                return AccessController.doPrivileged(this.PRIVILEGED_ACTION);
            }
        };

        public AccessAuditContext currentContext();
    }
}

