/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.remoting.Attribute;
import org.jboss.as.remoting.ConnectorCommon;
import org.jboss.as.remoting.Element;
import org.jboss.as.remoting.RemotingSubsystem11Parser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;

class RemotingSubsystem12Parser
extends RemotingSubsystem11Parser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    RemotingSubsystem12Parser() {
    }

    @Override
    void parseConnector(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        String name = null;
        String securityRealm = null;
        String socketBinding = null;
        String serverName = null;
        String saslProtocol = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME, Attribute.SOCKET_BINDING);
        int count = reader.getAttributeCount();
        ModelNode connector = new ModelNode();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case SECURITY_REALM: {
                    securityRealm = value;
                    continue block12;
                }
                case SOCKET_BINDING: {
                    socketBinding = value;
                    continue block12;
                }
                case SERVER_NAME: {
                    ConnectorCommon.SERVER_NAME.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block12;
                }
                case SASL_PROTOCOL: {
                    ConnectorCommon.SASL_PROTOCOL.parseAndSetParameter(value, connector, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        assert (name != null);
        assert (socketBinding != null);
        connector.get("operation").set("add");
        connector.get("address").set(address).add("connector", name);
        connector.get("socket-binding").set(socketBinding);
        if (securityRealm != null) {
            connector.get("security-realm").set(securityRealm);
        }
        if (serverName != null) {
            connector.get("server-name").set(serverName);
        }
        if (saslProtocol != null) {
            connector.get("sasl-protocol").set(saslProtocol);
        }
        list.add(connector);
        EnumSet<Element> visited = EnumSet.noneOf(Element.class);
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (visited.contains((Object)element)) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            visited.add(element);
            switch (element) {
                case SASL: {
                    this.parseSaslElement(reader, connector.get("address"), list);
                    continue block13;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, connector.get("address"), list);
                    continue block13;
                }
                case AUTHENTICATION_PROVIDER: {
                    connector.get("authentication-provider").set(ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name"));
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }
}

