/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.controller.git;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.RmCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.RevisionSyntaxException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.ContentRepositoryImpl;
import org.jboss.as.repository.ExplodedContent;
import org.jboss.as.repository.ExplodedContentException;
import org.jboss.as.server.controller.git.GitRepository;
import org.jboss.msc.service.ServiceTarget;

public class GitContentRepository
extends ContentRepositoryImpl {
    private final GitRepository gitRepository;

    protected GitContentRepository(GitRepository gitRepository, File repoRoot, File tmpRoot, long obsolescenceTimeout, long lockTimeout) {
        super(repoRoot, tmpRoot, obsolescenceTimeout, lockTimeout);
        this.gitRepository = gitRepository;
    }

    public byte[] removeContentFromExploded(byte[] deploymentHash, List<String> paths) throws ExplodedContentException {
        byte[] result = super.removeContentFromExploded(deploymentHash, paths);
        if (!Arrays.equals(deploymentHash, result)) {
            Path realFile = this.getDeploymentContentFile(result, true);
            try (Git git = this.gitRepository.getGit();){
                git.add().addFilepattern(this.gitRepository.getPattern(realFile)).call();
            }
            catch (GitAPIException ex) {
                throw new ExplodedContentException(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    public byte[] addContentToExploded(byte[] deploymentHash, List<ExplodedContent> addFiles, boolean overwrite) throws ExplodedContentException {
        byte[] result = super.addContentToExploded(deploymentHash, addFiles, overwrite);
        if (!Arrays.equals(deploymentHash, result)) {
            Path realFile = this.getDeploymentContentFile(result, true);
            try (Git git = this.gitRepository.getGit();){
                git.add().addFilepattern(this.gitRepository.getPattern(realFile)).call();
            }
            catch (GitAPIException ex) {
                throw new ExplodedContentException(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    public byte[] explodeSubContent(byte[] deploymentHash, String relativePath) throws ExplodedContentException {
        byte[] result = super.explodeSubContent(deploymentHash, relativePath);
        if (!Arrays.equals(deploymentHash, result)) {
            Path realFile = this.getDeploymentContentFile(result, true);
            try (Git git = this.gitRepository.getGit();){
                git.add().addFilepattern(this.gitRepository.getPattern(realFile)).call();
            }
            catch (GitAPIException ex) {
                throw new ExplodedContentException(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    public byte[] explodeContent(byte[] deploymentHash) throws ExplodedContentException {
        byte[] result = super.explodeContent(deploymentHash);
        if (!Arrays.equals(deploymentHash, result)) {
            Path realFile = this.getDeploymentContentFile(result, true);
            try (Git git = this.gitRepository.getGit();){
                git.add().addFilepattern(this.gitRepository.getPattern(realFile)).call();
            }
            catch (GitAPIException ex) {
                throw new ExplodedContentException(ex.getMessage(), (Throwable)ex);
            }
        }
        return result;
    }

    public void removeContent(ContentReference reference) {
        Path realFile = this.getDeploymentContentFile(reference.getHash());
        super.removeContent(reference);
        if (!Files.exists(realFile, new LinkOption[0])) {
            try (Git git = this.gitRepository.getGit();){
                Set deletedFiles = git.status().call().getMissing();
                RmCommand rmCommand = git.rm();
                for (String file : deletedFiles) {
                    rmCommand.addFilepattern(file);
                }
                rmCommand.addFilepattern(this.gitRepository.getPattern(realFile)).call();
            }
            catch (GitAPIException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public byte[] addContent(InputStream stream) throws IOException {
        byte[] result = super.addContent(stream);
        Path realFile = this.getDeploymentContentFile(result, true);
        try (Git git = this.gitRepository.getGit();){
            git.add().addFilepattern(this.gitRepository.getPattern(realFile)).call();
        }
        catch (GitAPIException ex) {
            throw new IOException(ex);
        }
        return result;
    }

    public void flush(boolean success) {
        if (success) {
            try (Git git = this.gitRepository.getGit();){
                Status status = git.status().call();
                if (!status.isClean()) {
                    String message = git.getRepository().parseCommit((AnyObjectId)git.getRepository().resolve("HEAD")).getFullMessage();
                    if (!status.getUntracked().isEmpty() || !status.getUntrackedFolders().isEmpty()) {
                        AddCommand addCommand = git.add();
                        for (String untracked : status.getUntrackedFolders()) {
                            addCommand = addCommand.addFilepattern(untracked);
                        }
                        for (String untracked : status.getUntracked()) {
                            addCommand = addCommand.addFilepattern(untracked);
                        }
                        addCommand.call();
                    }
                    git.commit().setMessage(message).setAmend(true).setAll(true).setNoVerify(true).call();
                }
            }
            catch (IOException | GitAPIException | RevisionSyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void addService(ServiceTarget serviceTarget, GitRepository gitRepository, File repoRoot, File tmpRoot) {
        ContentRepository.Factory.addService((ServiceTarget)serviceTarget, (ContentRepository)new GitContentRepository(gitRepository, repoRoot, tmpRoot, OBSOLETE_CONTENT_TIMEOUT, 5000L));
    }
}

